/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptUpdater;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.command.CommandHelp;
import ch.njol.skript.config.Config;
import ch.njol.skript.doc.HTMLGenerator;
import ch.njol.skript.localization.ArgsMessage;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.PluralizingArgsMessage;
import ch.njol.skript.log.RedirectingLogHandler;
import ch.njol.skript.log.TimingLogHandler;
import ch.njol.skript.tests.runner.SkriptTestEvent;
import ch.njol.skript.tests.runner.TestMode;
import ch.njol.skript.tests.runner.TestTracker;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.SkriptColor;
import ch.njol.util.OpenCloseable;
import ch.njol.util.StringUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class SkriptCommand
implements CommandExecutor {
    private static final String CONFIG_NODE = "skript command";
    private static final CommandHelp skriptCommandHelp = new CommandHelp("<gray>/<gold>skript", SkriptColor.LIGHT_CYAN, "skript command.help").add(new CommandHelp("reload", SkriptColor.DARK_RED).add("all").add("config").add("aliases").add("scripts").add("<script>")).add(new CommandHelp("enable", SkriptColor.DARK_RED).add("all").add("<script>")).add(new CommandHelp("disable", SkriptColor.DARK_RED).add("all").add("<script>")).add(new CommandHelp("update", SkriptColor.DARK_RED).add("check").add("changes").add("download")).add("info").add("help");
    private static final ArgsMessage m_reloading;
    private static final ArgsMessage m_reloaded;
    private static final ArgsMessage m_reload_error;
    private static final ArgsMessage m_invalid_script;
    private static final ArgsMessage m_invalid_folder;

    private static void reloading(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command.reload." + what) : Language.format("skript command.reload." + what, args);
        Skript.info(sender, StringUtils.fixCapitalization(m_reloading.toString(what)));
    }

    private static void reloaded(CommandSender sender, RedirectingLogHandler r, TimingLogHandler timingLogHandler, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command.reload." + what) : PluralizingArgsMessage.format(Language.format("skript command.reload." + what, args));
        String timeTaken = String.valueOf(timingLogHandler.getTimeTaken());
        if (r.numErrors() == 0) {
            Skript.info(sender, StringUtils.fixCapitalization(PluralizingArgsMessage.format(m_reloaded.toString(what, timeTaken))));
        } else {
            Skript.error(sender, StringUtils.fixCapitalization(PluralizingArgsMessage.format(m_reload_error.toString(what, r.numErrors(), timeTaken))));
        }
    }

    private static void info(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command." + what) : PluralizingArgsMessage.format(Language.format("skript command." + what, args));
        Skript.info(sender, StringUtils.fixCapitalization(what));
    }

    private static void error(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command." + what) : PluralizingArgsMessage.format(Language.format("skript command." + what, args));
        Skript.error(sender, StringUtils.fixCapitalization(what));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public boolean onCommand(@Nullable CommandSender sender, @Nullable Command command, @Nullable String label, @Nullable String[] args) {
        if (sender == null) throw new IllegalArgumentException();
        if (command == null) throw new IllegalArgumentException();
        if (label == null) throw new IllegalArgumentException();
        if (args == null) {
            throw new IllegalArgumentException();
        }
        if (!skriptCommandHelp.test(sender, args)) {
            return true;
        }
        try {
            Object desc;
            Iterator<SkriptAddon> updater2;
            block116: {
                Collection<File> scripts;
                File f;
                RedirectingLogHandler logHandler = new RedirectingLogHandler(sender, "").start();
                TimingLogHandler timingLogHandler = new TimingLogHandler().start();
                if (args[0].equalsIgnoreCase("reload")) {
                    if (args[1].equalsIgnoreCase("all")) {
                        SkriptCommand.reloading(sender, "config, aliases and scripts", new Object[0]);
                        SkriptConfig.load();
                        Aliases.clear();
                        Aliases.load();
                        if (!ScriptLoader.isAsync()) {
                            ScriptLoader.disableScripts();
                        }
                        ScriptLoader.loadScripts(OpenCloseable.combine(logHandler, timingLogHandler)).thenAccept(unused -> SkriptCommand.reloaded(sender, logHandler, timingLogHandler, "config, aliases and scripts", new Object[0]));
                        return true;
                    }
                    if (args[1].equalsIgnoreCase("scripts")) {
                        SkriptCommand.reloading(sender, "scripts", new Object[0]);
                        if (!ScriptLoader.isAsync()) {
                            ScriptLoader.disableScripts();
                        }
                        ScriptLoader.loadScripts(OpenCloseable.combine(logHandler, timingLogHandler)).thenAccept(unused -> SkriptCommand.reloaded(sender, logHandler, timingLogHandler, "scripts", new Object[0]));
                        return true;
                    }
                    if (args[1].equalsIgnoreCase("config")) {
                        SkriptCommand.reloading(sender, "main config", new Object[0]);
                        SkriptConfig.load();
                        SkriptCommand.reloaded(sender, logHandler, timingLogHandler, "main config", new Object[0]);
                        return true;
                    }
                    if (args[1].equalsIgnoreCase("aliases")) {
                        SkriptCommand.reloading(sender, "aliases", new Object[0]);
                        Aliases.clear();
                        Aliases.load();
                        SkriptCommand.reloaded(sender, logHandler, timingLogHandler, "aliases", new Object[0]);
                        return true;
                    }
                    f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                    if (f == null) {
                        boolean bl = true;
                        return bl;
                    }
                    if (f.isDirectory()) {
                        SkriptCommand.reloading(sender, "scripts in folder", f.getName());
                        ScriptLoader.reloadScripts(f, OpenCloseable.combine(logHandler, timingLogHandler)).thenAccept(scriptInfo -> {
                            int enabled = scriptInfo.files;
                            if (enabled == 0) {
                                SkriptCommand.info(sender, "reload.empty folder", f.getName());
                            } else {
                                SkriptCommand.reloaded(sender, logHandler, timingLogHandler, "x scripts in folder", f.getName(), enabled);
                            }
                        });
                        return true;
                    }
                    if (f.getName().startsWith("-")) {
                        SkriptCommand.info(sender, "reload.script disabled", f.getName().substring(1), StringUtils.join(args, " ", 1, args.length));
                        boolean bl = true;
                        return bl;
                    }
                    SkriptCommand.reloading(sender, "script", f.getName());
                    ScriptLoader.reloadScript(f, OpenCloseable.combine(logHandler, timingLogHandler)).thenAccept(scriptInfo -> SkriptCommand.reloaded(sender, logHandler, timingLogHandler, "script", f.getName()));
                    return true;
                }
                if (args[0].equalsIgnoreCase("enable")) {
                    if (args[1].equalsIgnoreCase("all")) {
                        try {
                            SkriptCommand.info(sender, "enable.all.enabling", new Object[0]);
                            File[] files = SkriptCommand.toggleScripts(new File(Skript.getInstance().getDataFolder(), "scripts"), true).toArray(new File[0]);
                            List<Config> configs = ScriptLoader.loadStructures(files);
                            ScriptLoader.loadScripts(configs, logHandler).thenAccept(scriptInfo -> {
                                if (logHandler.numErrors() == 0) {
                                    SkriptCommand.info(sender, "enable.all.enabled", new Object[0]);
                                } else {
                                    SkriptCommand.error(sender, "enable.all.error", logHandler.numErrors());
                                }
                            });
                            return true;
                        }
                        catch (IOException e) {
                            SkriptCommand.error(sender, "enable.all.io error", ExceptionUtils.toString(e));
                            return true;
                        }
                    }
                    f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                    if (f == null) {
                        boolean configs = true;
                        return configs;
                    }
                    if (!f.isDirectory()) {
                        if (!f.getName().startsWith("-")) {
                            SkriptCommand.info(sender, "enable.single.already enabled", f.getName(), StringUtils.join(args, " ", 1, args.length));
                            boolean configs = true;
                            return configs;
                        }
                        try {
                            f = FileUtils.move(f, new File(f.getParentFile(), f.getName().substring(1)), false);
                        }
                        catch (IOException e) {
                            SkriptCommand.error(sender, "enable.single.io error", f.getName().substring(1), ExceptionUtils.toString(e));
                            boolean bl = true;
                            if (timingLogHandler != null) {
                                timingLogHandler.close();
                            }
                            if (logHandler == null) return bl;
                            logHandler.close();
                            return bl;
                        }
                        SkriptCommand.info(sender, "enable.single.enabling", f.getName());
                        Config config = ScriptLoader.loadStructure(f);
                        if (config == null) {
                            boolean bl = true;
                            return bl;
                        }
                        String fileName = f.getName();
                        ScriptLoader.loadScripts(Collections.singletonList(config), logHandler).thenAccept(scriptInfo -> {
                            if (logHandler.numErrors() == 0) {
                                SkriptCommand.info(sender, "enable.single.enabled", fileName);
                            } else {
                                SkriptCommand.error(sender, "enable.single.error", fileName, logHandler.numErrors());
                            }
                        });
                        boolean bl = true;
                        return bl;
                    }
                    try {
                        scripts = SkriptCommand.toggleScripts(f, true);
                    }
                    catch (IOException e) {
                        SkriptCommand.error(sender, "enable.folder.io error", f.getName(), ExceptionUtils.toString(e));
                        boolean bl = true;
                        if (timingLogHandler != null) {
                            timingLogHandler.close();
                        }
                        if (logHandler == null) return bl;
                        logHandler.close();
                        return bl;
                    }
                    if (scripts.isEmpty()) {
                        SkriptCommand.info(sender, "enable.folder.empty", f.getName());
                        boolean e = true;
                        return e;
                    }
                    SkriptCommand.info(sender, "enable.folder.enabling", f.getName(), scripts.size());
                    File[] ss = scripts.toArray(new File[0]);
                    List<Config> configs = ScriptLoader.loadStructures(ss);
                    if (configs.size() == 0) {
                        boolean bl = true;
                        return bl;
                    }
                    String fileName = f.getName();
                    ScriptLoader.loadScripts(configs, logHandler).thenAccept(scriptInfo -> {
                        if (logHandler.numErrors() == 0) {
                            SkriptCommand.info(sender, "enable.folder.enabled", fileName, scriptInfo.files);
                        } else {
                            SkriptCommand.error(sender, "enable.folder.error", fileName, logHandler.numErrors());
                        }
                    });
                    boolean bl = true;
                    return bl;
                }
                if (args[0].equalsIgnoreCase("disable")) {
                    if (args[1].equalsIgnoreCase("all")) {
                        ScriptLoader.disableScripts();
                        try {
                            SkriptCommand.toggleScripts(new File(Skript.getInstance().getDataFolder(), "scripts"), false);
                            SkriptCommand.info(sender, "disable.all.disabled", new Object[0]);
                            return true;
                        }
                        catch (IOException e) {
                            SkriptCommand.error(sender, "disable.all.io error", ExceptionUtils.toString(e));
                            return true;
                        }
                    }
                    f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                    if (f == null) {
                        boolean scripts2 = true;
                        return scripts2;
                    }
                    if (!f.isDirectory()) {
                        if (f.getName().startsWith("-")) {
                            SkriptCommand.info(sender, "disable.single.already disabled", f.getName().substring(1));
                            boolean scripts2 = true;
                            return scripts2;
                        }
                        ScriptLoader.unloadScript(f);
                        try {
                            FileUtils.move(f, new File(f.getParentFile(), "-" + f.getName()), false);
                        }
                        catch (IOException e) {
                            SkriptCommand.error(sender, "disable.single.io error", f.getName(), ExceptionUtils.toString(e));
                            boolean ss = true;
                            if (timingLogHandler != null) {
                                timingLogHandler.close();
                            }
                            if (logHandler == null) return ss;
                            logHandler.close();
                            return ss;
                        }
                        SkriptCommand.info(sender, "disable.single.disabled", f.getName());
                    } else {
                        try {
                            scripts = SkriptCommand.toggleScripts(f, false);
                        }
                        catch (IOException e) {
                            SkriptCommand.error(sender, "disable.folder.io error", f.getName(), ExceptionUtils.toString(e));
                            boolean configs = true;
                            if (timingLogHandler != null) {
                                timingLogHandler.close();
                            }
                            if (logHandler == null) return configs;
                            logHandler.close();
                            return configs;
                        }
                        if (scripts.isEmpty()) {
                            SkriptCommand.info(sender, "disable.folder.empty", f.getName());
                            boolean e = true;
                            return e;
                        }
                        for (File script : scripts) {
                            ScriptLoader.unloadScript(new File(script.getParentFile(), script.getName().substring(1)));
                        }
                        SkriptCommand.info(sender, "disable.folder.disabled", f.getName(), scripts.size());
                    }
                    boolean scripts3 = true;
                    return scripts3;
                }
                if (args[0].equalsIgnoreCase("update")) {
                    SkriptUpdater updater2 = Skript.getInstance().getUpdater();
                    if (updater2 == null) {
                        Skript.info(sender, "" + SkriptUpdater.m_internal_error);
                        boolean scripts3 = true;
                        return scripts3;
                    }
                    if (args[1].equalsIgnoreCase("check")) {
                        updater2.updateCheck(sender);
                        return true;
                    }
                    if (args[1].equalsIgnoreCase("changes")) {
                        updater2.changesCheck(sender);
                        return true;
                    }
                    if (!args[1].equalsIgnoreCase("download")) return true;
                    updater2.updateCheck(sender);
                    return true;
                }
                if (args[0].equalsIgnoreCase("info")) {
                    SkriptCommand.info(sender, "info.aliases", new Object[0]);
                    SkriptCommand.info(sender, "info.documentation", new Object[0]);
                    SkriptCommand.info(sender, "info.tutorials", new Object[0]);
                    SkriptCommand.info(sender, "info.server", Bukkit.getVersion());
                    SkriptCommand.info(sender, "info.version", Skript.getVersion());
                    SkriptCommand.info(sender, "info.addons", Skript.getAddons().isEmpty() ? "None" : "");
                    updater2 = Skript.getAddons().iterator();
                    break block116;
                } else {
                    File script;
                    if (args[0].equalsIgnoreCase("help")) {
                        skriptCommandHelp.showHelp(sender);
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("gen-docs")) {
                        File templateDir = new File(Skript.getInstance().getDataFolder() + "/doc-templates/");
                        if (!templateDir.exists()) {
                            Skript.error(sender, "Cannot generate docs! Documentation templates not found at 'plugins/Skript/doc-templates/'");
                            TestMode.docsFailed = true;
                            boolean dependenciesFound = true;
                            return dependenciesFound;
                        }
                        File outputDir = new File(Skript.getInstance().getDataFolder() + "/docs");
                        outputDir.mkdirs();
                        HTMLGenerator generator = new HTMLGenerator(templateDir, outputDir);
                        Skript.info(sender, "Generating docs...");
                        generator.generate();
                        Skript.info(sender, "Documentation generated!");
                        return true;
                    }
                    if (!args[0].equalsIgnoreCase("test")) return true;
                    if (!TestMode.DEV_MODE) return true;
                    if (args.length == 1) {
                        script = TestMode.lastTestFile;
                        if (script == null) {
                            Skript.error(sender, "No test script has been run yet!");
                            boolean outputDir = true;
                            return outputDir;
                        }
                    } else {
                        TestMode.lastTestFile = script = TestMode.TEST_DIR.resolve(Arrays.stream(args).skip(1L).collect(Collectors.joining(" ")) + ".sk").toFile();
                    }
                    if (!script.exists()) {
                        Skript.info(sender, "Test script doesn't exist!");
                        boolean outputDir = true;
                        return outputDir;
                    }
                    Config config = ScriptLoader.loadStructure(script);
                    if (config == null) return true;
                    ScriptLoader.loadScripts(Collections.singletonList(config), logHandler).thenAccept(scriptInfo -> Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), () -> {
                        String[] lines;
                        Bukkit.getPluginManager().callEvent((Event)new SkriptTestEvent());
                        ScriptLoader.disableScripts();
                        for (String line : lines = TestTracker.collectResults().createReport().split("\n")) {
                            Skript.info(sender, line);
                        }
                    }));
                    return true;
                }
                finally {
                    if (timingLogHandler != null) {
                        timingLogHandler.close();
                    }
                }
                finally {
                    if (logHandler != null) {
                        logHandler.close();
                    }
                }
            }
            while (updater2.hasNext()) {
                SkriptAddon addon = updater2.next();
                desc = addon.plugin.getDescription();
                String web = desc.getWebsite();
                Skript.info(sender, " - " + desc.getFullName() + (web != null ? " (" + web + ")" : ""));
            }
            List dependencies = Skript.getInstance().getDescription().getSoftDepend();
            boolean dependenciesFound = false;
            for (String dep : dependencies) {
                if (Bukkit.getPluginManager().getPlugin(dep) == null) continue;
                dependenciesFound = true;
            }
            SkriptCommand.info(sender, "info.dependencies", dependenciesFound ? "" : "None");
            desc = dependencies.iterator();
            while (desc.hasNext()) {
                String dep;
                dep = (String)desc.next();
                Plugin plugin = Bukkit.getPluginManager().getPlugin(dep);
                if (plugin == null) continue;
                String ver = plugin.getDescription().getVersion();
                Skript.info(sender, " - " + plugin.getName() + " v" + ver);
            }
            return true;
        }
        catch (Exception e) {
            Skript.exception((Throwable)e, "Exception occurred in Skript's main command", "Used command: /" + label + " " + StringUtils.join(args, " "));
        }
        return true;
    }

    private static @Nullable File getScriptFromArgs(CommandSender sender, String[] args, int start) {
        String script = StringUtils.join(args, " ", start, args.length);
        File f = SkriptCommand.getScriptFromName(script);
        if (f == null) {
            Skript.error(sender, (script.endsWith("/") || script.endsWith("\\") ? m_invalid_folder : m_invalid_script).toString(script));
            return null;
        }
        return f;
    }

    public static @Nullable File getScriptFromName(String script) {
        File f;
        boolean isFolder;
        boolean bl = isFolder = script.endsWith("/") || script.endsWith("\\");
        if (isFolder) {
            script = script.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        } else if (!StringUtils.endsWithIgnoreCase(script, ".sk")) {
            int dot = script.lastIndexOf(46);
            if (dot > 0 && !script.substring(dot + 1).equals("")) {
                return null;
            }
            script = script + ".sk";
        }
        if (script.startsWith("-")) {
            script = script.substring(1);
        }
        if (!(f = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator + script)).exists() && !(f = new File(f.getParentFile(), "-" + f.getName())).exists()) {
            return null;
        }
        return f;
    }

    private static Collection<File> toggleScripts(File folder, boolean enable) throws IOException {
        return FileUtils.renameAll(folder, name -> {
            if (StringUtils.endsWithIgnoreCase(name, ".sk") && name.startsWith("-") == enable) {
                return enable ? name.substring(1) : "-" + name;
            }
            return null;
        });
    }

    static {
        if (TestMode.GEN_DOCS || new File(Skript.getInstance().getDataFolder() + "/doc-templates").exists()) {
            skriptCommandHelp.add("gen-docs");
        }
        if (TestMode.DEV_MODE) {
            skriptCommandHelp.add("test");
        }
        m_reloading = new ArgsMessage("skript command.reload.reloading");
        m_reloaded = new ArgsMessage("skript command.reload.reloaded");
        m_reload_error = new ArgsMessage("skript command.reload.error");
        m_invalid_script = new ArgsMessage("skript command.invalid script");
        m_invalid_folder = new ArgsMessage("skript command.invalid folder");
    }
}

