/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;

public class EntityUtils {
    private static final boolean HAS_PIGLINS = Skript.classExists("org.bukkit.entity.Piglin");
    private static final BiMap<EntityData, EntityType> SPAWNER_TYPES = HashBiMap.create();

    public static boolean isAgeable(Entity entity) {
        if (entity instanceof Ageable || entity instanceof Zombie) {
            return true;
        }
        return HAS_PIGLINS && (entity instanceof Piglin || entity instanceof Zoglin);
    }

    public static int getAge(Entity entity) {
        if (entity instanceof Ageable) {
            return ((Ageable)entity).getAge();
        }
        if (entity instanceof Zombie) {
            return ((Zombie)entity).isBaby() ? -1 : 0;
        }
        if (HAS_PIGLINS) {
            if (entity instanceof Piglin) {
                return ((Piglin)entity).isBaby() ? -1 : 0;
            }
            if (entity instanceof Zoglin) {
                return ((Zoglin)entity).isBaby() ? -1 : 0;
            }
        }
        return 0;
    }

    public static void setAge(Entity entity, int age) {
        if (entity instanceof Ageable) {
            ((Ageable)entity).setAge(age);
        } else if (entity instanceof Zombie) {
            ((Zombie)entity).setBaby(age < 0);
        } else if (HAS_PIGLINS) {
            if (entity instanceof Piglin) {
                ((Piglin)entity).setBaby(age < 0);
            } else if (entity instanceof Zoglin) {
                ((Zoglin)entity).setBaby(age < 0);
            }
        }
    }

    public static void setBaby(Entity entity) {
        EntityUtils.setAge(entity, -24000);
    }

    public static void setAdult(Entity entity) {
        EntityUtils.setAge(entity, 0);
    }

    public static boolean isAdult(Entity entity) {
        return EntityUtils.getAge(entity) >= 0;
    }

    public static EntityType toBukkitEntityType(EntityData e) {
        return (EntityType)SPAWNER_TYPES.get(EntityData.fromClass(e.getType()));
    }

    public static EntityData toSkriptEntityData(EntityType e) {
        return (EntityData)SPAWNER_TYPES.inverse().get((Object)e);
    }

    static {
        for (EntityType e : EntityType.values()) {
            Class c = e.getEntityClass();
            if (c == null) continue;
            SPAWNER_TYPES.put(EntityData.fromClass(c), (Object)e);
        }
    }
}

