/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import ch.njol.skript.Skript;
import ch.njol.skript.util.Task;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public abstract class PlayerUtils {
    static final Set<Player> inviUpdate = new HashSet<Player>();
    static final Task task = new Task((Plugin)Skript.getInstance(), 1L, 1L){

        @Override
        public void run() {
            block3: {
                try {
                    for (Player p : inviUpdate) {
                        p.updateInventory();
                    }
                }
                catch (NullPointerException e) {
                    if (!Skript.debug()) break block3;
                    e.printStackTrace();
                }
            }
            inviUpdate.clear();
        }
    };
    private static final boolean hasCollecionGetOnlinePlayers = Skript.methodExists(Bukkit.class, "getOnlinePlayers", new Class[0], Collection.class);
    private static @Nullable Method getOnlinePlayers = null;

    private PlayerUtils() {
    }

    public static void updateInventory(@Nullable Player p) {
        if (p != null) {
            inviUpdate.add(p);
        }
    }

    public static Collection<? extends Player> getOnlinePlayers() {
        if (hasCollecionGetOnlinePlayers) {
            return ImmutableList.copyOf((Collection)Bukkit.getOnlinePlayers());
        }
        if (getOnlinePlayers == null) {
            try {
                getOnlinePlayers = Bukkit.class.getDeclaredMethod("getOnlinePlayers", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                Skript.outdatedError(e);
            }
            catch (SecurityException e) {
                Skript.exception((Throwable)e, new String[0]);
            }
        }
        try {
            Object o = getOnlinePlayers.invoke(null, new Object[0]);
            if (o instanceof Collection) {
                return ImmutableList.copyOf((Collection)((Collection)o));
            }
            return Arrays.asList((Player[])((Player[])o).clone());
        }
        catch (IllegalAccessException e) {
            Skript.outdatedError(e);
        }
        catch (IllegalArgumentException e) {
            Skript.outdatedError(e);
        }
        catch (InvocationTargetException e) {
            Skript.exception((Throwable)e, new String[0]);
        }
        return Collections.emptyList();
    }

    public static boolean canEat(Player p, Material food) {
        boolean special;
        GameMode gm = p.getGameMode();
        if (gm == GameMode.CREATIVE || gm == GameMode.SPECTATOR) {
            return false;
        }
        boolean edible = food.isEdible();
        if (!edible) {
            return false;
        }
        switch (food) {
            case GOLDEN_APPLE: 
            case CHORUS_FRUIT: {
                special = true;
                break;
            }
            default: {
                special = false;
            }
        }
        return p.getFoodLevel() < 20 || special;
    }
}

