/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.entity.BoatChestData;
import ch.njol.skript.entity.BoatData;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.entity.RabbitData;
import ch.njol.skript.registrations.Comparators;
import ch.njol.skript.util.BlockUtils;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.Experience;
import ch.njol.skript.util.GameruleValue;
import ch.njol.skript.util.StructureType;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timeperiod;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.slot.EquipmentSlot;
import ch.njol.skript.util.slot.Slot;
import ch.njol.skript.util.slot.SlotWithIndex;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wither;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class DefaultComparators {
    public static final Comparator<EntityData, ItemType> entityItemComparator;

    static {
        Comparators.registerComparator(Number.class, Number.class, new Comparator<Number, Number>(){

            @Override
            public Comparator.Relation compare(Number n1, Number n2) {
                if (n1 instanceof Long && n2 instanceof Long) {
                    return Comparator.Relation.get(n1.longValue() - n2.longValue());
                }
                Double d1 = n1.doubleValue();
                Double d2 = n2.doubleValue();
                if (d1.isNaN() || d2.isNaN()) {
                    return Comparator.Relation.SMALLER;
                }
                if (d1.isInfinite() || d2.isInfinite()) {
                    return d1 > d2 ? Comparator.Relation.GREATER : (d1 < d2 ? Comparator.Relation.SMALLER : Comparator.Relation.EQUAL);
                }
                double diff = d1 - d2;
                if (Math.abs(diff) < 1.0E-10) {
                    return Comparator.Relation.EQUAL;
                }
                return Comparator.Relation.get(diff);
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(Slot.class, Slot.class, new Comparator<Slot, Slot>(){

            @Override
            public Comparator.Relation compare(Slot o1, Slot o2) {
                if (o1 instanceof EquipmentSlot != o2 instanceof EquipmentSlot) {
                    return Comparator.Relation.NOT_EQUAL;
                }
                if (o1.isSameSlot(o2)) {
                    return Comparator.Relation.EQUAL;
                }
                return Comparator.Relation.NOT_EQUAL;
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Slot.class, Number.class, new Comparator<Slot, Number>(){

            @Override
            public Comparator.Relation compare(Slot o1, Number o2) {
                if (o1 instanceof SlotWithIndex) {
                    return Comparator.Relation.get(((SlotWithIndex)o1).getIndex() - o2.intValue());
                }
                return Comparator.Relation.NOT_EQUAL;
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(Slot.class, ItemType.class, new Comparator<Slot, ItemType>(){

            @Override
            public Comparator.Relation compare(Slot slot, ItemType item) {
                ItemStack stack = slot.getItem();
                if (stack == null || stack.getAmount() == 0) {
                    return Comparators.compare(new ItemType(Material.AIR), item);
                }
                return Comparators.compare(new ItemType(stack), item);
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(ItemType.class, Slot.class, new Comparator<ItemType, Slot>(){

            @Override
            public Comparator.Relation compare(ItemType item, Slot slot) {
                ItemStack stack = slot.getItem();
                if (stack == null || stack.getAmount() == 0) {
                    return Comparators.compare(item, new ItemType(Material.AIR));
                }
                return Comparators.compare(item, new ItemType(stack));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(ItemStack.class, ItemType.class, new Comparator<ItemStack, ItemType>(){

            @Override
            public Comparator.Relation compare(ItemStack is, ItemType it) {
                return Comparators.compare(new ItemType(is), it);
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(ItemType.class, ItemStack.class, new Comparator<ItemType, ItemStack>(){

            @Override
            public Comparator.Relation compare(ItemType it, ItemStack is) {
                return Comparators.compare(it, new ItemType(is));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Block.class, ItemType.class, new Comparator<Block, ItemType>(){

            @Override
            public Comparator.Relation compare(Block b, ItemType it) {
                return Comparators.compare(new ItemType(b), it);
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        if (Skript.classExists("org.bukkit.block.data.BlockData")) {
            Comparators.registerComparator(Block.class, BlockData.class, new Comparator<Block, BlockData>(){

                @Override
                public Comparator.Relation compare(Block block, BlockData data) {
                    return Comparator.Relation.get(block.getBlockData().matches(data));
                }

                @Override
                public boolean supportsOrdering() {
                    return false;
                }
            });
        }
        Comparators.registerComparator(ItemType.class, ItemType.class, new Comparator<ItemType, ItemType>(){

            @Override
            public Comparator.Relation compare(ItemType i1, ItemType i2) {
                int otherAmount = i2.getAmount();
                if (i1.getAmount() != otherAmount) {
                    if (otherAmount != 1) {
                        return Comparator.Relation.NOT_EQUAL;
                    }
                    for (ItemData itemData : i2.getTypes()) {
                        if (itemData.isAlias()) continue;
                        return Comparator.Relation.NOT_EQUAL;
                    }
                }
                return Comparator.Relation.get(i1.isSimilar(i2));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Block.class, Block.class, new Comparator<Block, Block>(){

            @Override
            public Comparator.Relation compare(Block b1, Block b2) {
                return Comparator.Relation.get(BlockUtils.extractBlock(b1).equals(BlockUtils.extractBlock(b2)));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Entity.class, EntityData.class, new Comparator<Entity, EntityData>(){

            @Override
            public Comparator.Relation compare(Entity e, EntityData t) {
                return Comparator.Relation.get(t.isInstance(e));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(EntityData.class, EntityData.class, new Comparator<EntityData, EntityData>(){

            @Override
            public Comparator.Relation compare(EntityData t1, EntityData t2) {
                return Comparator.Relation.get(t2.isSupertypeOf(t1));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        entityItemComparator = new Comparator<EntityData, ItemType>(){

            @Override
            public Comparator.Relation compare(EntityData e, ItemType i) {
                if (e instanceof Item) {
                    return Comparator.Relation.get(i.isOfType(((Item)e).getItemStack()));
                }
                if (e instanceof BoatData) {
                    return Comparator.Relation.get(((BoatData)e).isOfItemType(i));
                }
                if (e instanceof BoatChestData) {
                    return Comparator.Relation.get(((BoatChestData)e).isOfItemType(i));
                }
                if (e instanceof RabbitData) {
                    return Comparator.Relation.get(i.isOfType(Material.RABBIT));
                }
                for (ItemData data : i.getTypes()) {
                    assert (data != null);
                    EntityData<?> entity = Aliases.getRelatedEntity(data);
                    if (entity == null || !entity.getType().isAssignableFrom(e.getType())) continue;
                    return Comparator.Relation.EQUAL;
                }
                return Comparator.Relation.NOT_EQUAL;
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        };
        Comparators.registerComparator(EntityData.class, ItemType.class, entityItemComparator);
        Comparators.registerComparator(Entity.class, ItemType.class, new Comparator<Entity, ItemType>(){

            @Override
            public Comparator.Relation compare(Entity entity, ItemType item) {
                return entityItemComparator.compare(EntityData.fromEntity(entity), item);
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(CommandSender.class, CommandSender.class, new Comparator<CommandSender, CommandSender>(){

            @Override
            public Comparator.Relation compare(CommandSender s1, CommandSender s2) {
                return Comparator.Relation.get(s1.equals(s2));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(OfflinePlayer.class, OfflinePlayer.class, new Comparator<OfflinePlayer, OfflinePlayer>(){

            @Override
            public Comparator.Relation compare(OfflinePlayer p1, OfflinePlayer p2) {
                return Comparator.Relation.get(Objects.equals(p1.getName(), p2.getName()));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(OfflinePlayer.class, String.class, new Comparator<OfflinePlayer, String>(){

            @Override
            public Comparator.Relation compare(OfflinePlayer p, String name) {
                String offlineName = p.getName();
                return offlineName == null ? Comparator.Relation.NOT_EQUAL : Comparator.Relation.get(offlineName.equalsIgnoreCase(name));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(World.class, String.class, new Comparator<World, String>(){

            @Override
            public Comparator.Relation compare(World w, String name) {
                return Comparator.Relation.get(w.getName().equalsIgnoreCase(name));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(String.class, String.class, new Comparator<String, String>(){

            @Override
            public Comparator.Relation compare(String s1, String s2) {
                return Comparator.Relation.get(StringUtils.equals(s1, s2, SkriptConfig.caseSensitive.value()));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Date.class, Date.class, new Comparator<Date, Date>(){

            @Override
            public Comparator.Relation compare(Date d1, Date d2) {
                return Comparator.Relation.get(d1.compareTo(d2));
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(Time.class, Time.class, new Comparator<Time, Time>(){

            @Override
            public Comparator.Relation compare(Time t1, Time t2) {
                return Comparator.Relation.get(t1.getTime() - t2.getTime());
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(Timespan.class, Timespan.class, new Comparator<Timespan, Timespan>(){

            @Override
            public Comparator.Relation compare(Timespan t1, Timespan t2) {
                return Comparator.Relation.get(t1.getMilliSeconds() - t2.getMilliSeconds());
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(Time.class, Timeperiod.class, new Comparator<Time, Timeperiod>(){

            @Override
            public Comparator.Relation compare(Time t, Timeperiod p) {
                return Comparator.Relation.get(p.contains(t));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(StructureType.class, StructureType.class, new Comparator<StructureType, StructureType>(){

            @Override
            public Comparator.Relation compare(StructureType s1, StructureType s2) {
                return Comparator.Relation.get(CollectionUtils.containsAll(s2.getTypes(), s2.getTypes()));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Object.class, ClassInfo.class, new Comparator<Object, ClassInfo>(){

            @Override
            public Comparator.Relation compare(Object o, ClassInfo c) {
                return Comparator.Relation.get(c.getC().isInstance(o) || o instanceof ClassInfo && c.getC().isAssignableFrom(((ClassInfo)o).getC()));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        final ItemType lava = Aliases.javaItemType("lava");
        Comparators.registerComparator(EntityDamageEvent.DamageCause.class, ItemType.class, new Comparator<EntityDamageEvent.DamageCause, ItemType>(){

            @Override
            public Comparator.Relation compare(EntityDamageEvent.DamageCause dc, ItemType t) {
                switch (dc) {
                    case FIRE: {
                        return Comparator.Relation.get(t.isOfType(Material.FIRE));
                    }
                    case LAVA: {
                        return Comparator.Relation.get(t.equals(lava));
                    }
                    case MAGIC: {
                        return Comparator.Relation.get(t.isOfType(Material.POTION));
                    }
                }
                if (Skript.fieldExists(EntityDamageEvent.DamageCause.class, "HOT_FLOOR") && dc.equals((Object)EntityDamageEvent.DamageCause.HOT_FLOOR)) {
                    return Comparator.Relation.get(t.isOfType(Material.MAGMA_BLOCK));
                }
                return Comparator.Relation.NOT_EQUAL;
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(EntityDamageEvent.DamageCause.class, EntityData.class, new Comparator<EntityDamageEvent.DamageCause, EntityData>(){

            @Override
            public Comparator.Relation compare(EntityDamageEvent.DamageCause dc, EntityData e) {
                switch (dc) {
                    case ENTITY_ATTACK: {
                        return Comparator.Relation.get(EntityData.fromClass(Entity.class).isSupertypeOf(e));
                    }
                    case PROJECTILE: {
                        return Comparator.Relation.get(EntityData.fromClass(Projectile.class).isSupertypeOf(e));
                    }
                    case WITHER: {
                        return Comparator.Relation.get(EntityData.fromClass(Wither.class).isSupertypeOf(e));
                    }
                    case FALLING_BLOCK: {
                        return Comparator.Relation.get(EntityData.fromClass(FallingBlock.class).isSupertypeOf(e));
                    }
                }
                return Comparator.Relation.NOT_EQUAL;
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(GameruleValue.class, GameruleValue.class, new Comparator<GameruleValue, GameruleValue>(){

            @Override
            public Comparator.Relation compare(GameruleValue o1, GameruleValue o2) {
                return Comparator.Relation.get(o1.equals(o2));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(GameruleValue.class, Number.class, new Comparator<GameruleValue, Number>(){

            @Override
            public Comparator.Relation compare(GameruleValue o1, Number o2) {
                if (!(o1.getGameruleValue() instanceof Number)) {
                    return Comparator.Relation.NOT_EQUAL;
                }
                Number gameruleValue = (Number)o1.getGameruleValue();
                return Comparators.compare(gameruleValue, o2);
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(GameruleValue.class, Boolean.class, new Comparator<GameruleValue, Boolean>(){

            @Override
            public Comparator.Relation compare(GameruleValue o1, Boolean o2) {
                if (!(o1.getGameruleValue() instanceof Boolean)) {
                    return Comparator.Relation.NOT_EQUAL;
                }
                return Comparator.Relation.get(o2.equals(o1.getGameruleValue()));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        if (Skript.isRunningMinecraft(1, 11)) {
            Comparators.registerComparator(EnchantmentOffer.class, EnchantmentType.class, new Comparator<EnchantmentOffer, EnchantmentType>(){

                @Override
                public Comparator.Relation compare(EnchantmentOffer eo, EnchantmentType et) {
                    return Comparator.Relation.get(eo.getEnchantment() == et.getType() && eo.getEnchantmentLevel() == et.getLevel());
                }

                @Override
                public boolean supportsOrdering() {
                    return false;
                }
            });
            Comparators.registerComparator(EnchantmentOffer.class, Experience.class, new Comparator<EnchantmentOffer, Experience>(){

                @Override
                public Comparator.Relation compare(EnchantmentOffer eo, Experience exp) {
                    return Comparator.Relation.get(eo.getCost() == exp.getXP());
                }

                @Override
                public boolean supportsOrdering() {
                    return false;
                }
            });
        }
        Comparators.registerComparator(Inventory.class, InventoryType.class, new Comparator<Inventory, InventoryType>(){

            @Override
            public Comparator.Relation compare(Inventory inventory, InventoryType inventoryType) {
                return Comparator.Relation.get(inventory.getType() == inventoryType);
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
    }
}

