/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Loaded")
@Description(value={"Checks whether or not a chunk/world is loaded. 'chunk at 1, 1' uses chunk coords, which are location coords divided by 16."})
@Examples(value={"if chunk at {home::%player's uuid%} is loaded:", "if chunk 1, 10 in world \"world\" is loaded:", "if world(\"lobby\") is loaded:"})
@Since(value="2.3, 2.5 (revamp with chunk at location/coords)")
public class CondIsLoaded
extends Condition {
    private @Nullable Expression<Location> locations;
    private @Nullable Expression<Number> x;
    private @Nullable Expression<Number> z;
    private @Nullable Expression<World> world;
    private int pattern;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        this.locations = this.pattern == 0 ? Direction.combine(exprs[0], exprs[1]) : null;
        this.x = this.pattern == 1 ? exprs[0] : null;
        Expression<Object> expression = this.z = this.pattern == 1 ? exprs[1] : null;
        this.world = this.pattern == 1 ? exprs[2] : (this.pattern == 2 ? exprs[0] : null);
        this.setNegated(parseResult.mark == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        switch (this.pattern) {
            case 0: {
                return this.locations.check(e, location -> {
                    World world = location.getWorld();
                    if (world != null) {
                        return world.isChunkLoaded(location.getBlockX() >> 4, location.getBlockZ() >> 4);
                    }
                    return false;
                }, this.isNegated());
            }
            case 1: {
                return this.world.check(e, world -> {
                    Number x = this.x.getSingle(e);
                    Number z = this.z.getSingle(e);
                    if (x == null || z == null) {
                        return false;
                    }
                    return world.isChunkLoaded(x.intValue(), z.intValue());
                }, this.isNegated());
            }
            case 2: {
                return this.world.check(e, world -> Bukkit.getWorld((String)world.getName()) != null, this.isNegated());
            }
        }
        return false;
    }

    @Override
    public String toString(@Nullable Event e, boolean d) {
        String chunkC;
        String neg;
        String string = neg = this.isNegated() ? " not " : " ";
        String chunk = this.pattern == 0 ? "chunk[s] at " + this.locations.toString(e, d) + (this.locations.isSingle() ? " is" : " are") + neg + "loaded" : "";
        String string2 = chunkC = this.pattern == 1 ? "chunk (x:" + this.x.toString(e, d) + ",z:" + this.z.toString(e, d) + ",w:" + this.world.toString(e, d) + ") is" + neg + "loaded" : "";
        String world = this.pattern == 2 ? "world[s] " + this.world.toString(e, d) + (this.world.isSingle() ? " is" : " are") + neg + "loaded" : "";
        return chunk + chunkC + world;
    }

    static {
        Skript.registerCondition(CondIsLoaded.class, "chunk[s] %directions% [%locations%] (is|are)[(1\u00a6(n't| not))] loaded", "chunk [at] %number%, %number% (in|of) [world] %world% is[(1\u00a6(n't| not))] loaded", "[world[s]] %worlds% (is|are)[(1\u00a6(n't| not))] loaded");
    }
}

