/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.OfflinePlayer;

@Name(value="Is Online")
@Description(value={"Checks whether a player is online."})
@Examples(value={"player is online", "player-argument is offline"})
@Since(value="1.4")
public class CondIsOnline
extends PropertyCondition<OfflinePlayer> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.setNegated(matchedPattern == 1 ^ parseResult.mark == 1);
        return true;
    }

    @Override
    public boolean check(OfflinePlayer op) {
        return op.isOnline();
    }

    @Override
    protected String getPropertyName() {
        return "online";
    }

    static {
        CondIsOnline.register(CondIsOnline.class, "(online|1\u00a6offline)", "offlineplayers");
    }
}

