/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import java.util.Random;
import org.bukkit.Chunk;

@Name(value="Is Slime Chunk")
@Description(value={"Tests whether a chunk is a so-called slime chunk.", "Slimes can generally spawn in the swamp biome and in slime chunks.", "For more info, see <a href='https://minecraft.gamepedia.com/Slime#.22Slime_chunks.22'>the Minecraft wiki</a>."})
@Examples(value={"command /slimey:", "\ttrigger:", "\t\tif chunk at player is a slime chunk:", "\t\t\tsend \"Yeah, it is!\"", "\t\telse:", "\t\t\tsend \"Nope, it isn't\""})
@Since(value="2.3")
public class CondIsSlimeChunk
extends PropertyCondition<Chunk> {
    private static final boolean CHUNK_METHOD_EXISTS = Skript.methodExists(Chunk.class, "isSlimeChunk", new Class[0]);

    @Override
    public boolean check(Chunk chunk) {
        if (CHUNK_METHOD_EXISTS) {
            return chunk.isSlimeChunk();
        }
        Random random = new Random(chunk.getWorld().getSeed() + 4987142L * (long)chunk.getX() * (long)chunk.getX() + 5947611L * (long)chunk.getX() + 4392871L * (long)chunk.getZ() * (long)chunk.getZ() + (389711L * (long)chunk.getZ() ^ 0x3AD8025FL));
        return random.nextInt(10) == 0;
    }

    @Override
    protected String getPropertyName() {
        return "slime chunk";
    }

    static {
        CondIsSlimeChunk.register(CondIsSlimeChunk.class, "([a] slime chunk|slime chunks|slimey)", "chunk");
    }
}

