/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Has Played Before")
@Description(value={"Checks whether a player has played on this server before. You can also use <a href='events.html#first_join'>on first join</a> if you want to make triggers for new players."})
@Examples(value={"player has played on this server before", "player hasn't played before"})
@Since(value="1.4")
public class CondPlayedBefore
extends Condition {
    private Expression<OfflinePlayer> player;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.player.check(e, OfflinePlayer::hasPlayedBefore, this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.player.toString(e, debug) + (this.isNegated() ? " hasn't" : " has") + " played on this server before";
    }

    static {
        Skript.registerCondition(CondPlayedBefore.class, "%offlineplayer% [(has|did)] [already] play[ed] [on (this|the) server] (before|already)", "%offlineplayer% (has not|hasn't|did not|didn't) [(already|yet)] play[ed] [on (this|the) server] (before|already|yet)");
    }
}

