/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Charge Creeper")
@Description(value={"Charges or uncharges a creeper. A creeper is charged when it has been struck by lightning."})
@Examples(value={"on spawn of creeper:", "\tcharge the event-entity"})
@Since(value="2.5")
public class EffChargeCreeper
extends Effect {
    private Expression<LivingEntity> entities;
    private boolean charge;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.charge = parseResult.mark != 1;
        return true;
    }

    @Override
    protected void execute(Event e) {
        for (LivingEntity le : this.entities.getArray(e)) {
            if (!(le instanceof Creeper)) continue;
            ((Creeper)le).setPowered(this.charge);
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "make " + this.entities.toString(e, debug) + (this.charge ? " charged" : " not charged");
    }

    static {
        Skript.registerEffect(EffChargeCreeper.class, "make %livingentities% [a[n]] (charged|powered|1\u00a6((un|non[-])charged|(un|non[-])powered)) [creeper[s]]", "(charge|power|1\u00a6(uncharge|unpower)) %livingentities%");
    }
}

