/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.util.StringMode;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Command")
@Description(value={"Executes a command. This can be useful to use other plugins in triggers."})
@Examples(value={"make player execute command \"/suicide\"", "execute console command \"/say Hello everyone!\""})
@Since(value="1.0")
public class EffCommand
extends Effect {
    private @Nullable Expression<CommandSender> senders;
    private Expression<String> commands;

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (matchedPattern == 0) {
            this.commands = vars[0];
            this.senders = vars[1];
        } else {
            this.senders = vars[0];
            this.commands = vars[1];
        }
        this.commands = VariableString.setStringMode(this.commands, StringMode.COMMAND);
        return true;
    }

    @Override
    public void execute(Event e) {
        for (String command : this.commands.getArray(e)) {
            assert (command != null);
            if (command.startsWith("/")) {
                command = "" + command.substring(1);
            }
            if (this.senders != null) {
                for (CommandSender sender : this.senders.getArray(e)) {
                    assert (sender != null);
                    Skript.dispatchCommand(sender, command);
                }
                continue;
            }
            Skript.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "make " + (this.senders != null ? this.senders.toString(e, debug) : "the console") + " execute the command " + this.commands.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffCommand.class, "[execute] [the] command %strings% [by %-commandsenders%]", "[execute] [the] %commandsenders% command %strings%", "(let|make) %commandsenders% execute [[the] command] %strings%");
    }
}

