/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Ignite/Extinguish")
@Description(value={"Lights entities on fire or extinguishes them."})
@Examples(value={"ignite the player", "extinguish the player"})
@Since(value="1.4")
public class EffIgnite
extends Effect {
    private static final int DEFAULT_DURATION = 160;
    private Expression<Entity> entities;
    private boolean ignite;
    private @Nullable Expression<Timespan> duration = null;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        boolean bl = this.ignite = exprs.length > 1;
        if (this.ignite) {
            this.duration = exprs[1];
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        int d;
        if (this.duration != null) {
            Timespan t = this.duration.getSingle(e);
            if (t == null) {
                return;
            }
            d = (int)(t.getTicks_i() >= Integer.MAX_VALUE ? Integer.MAX_VALUE : t.getTicks_i());
        } else {
            d = this.ignite ? 160 : 0;
        }
        for (final Entity en : this.entities.getArray(e)) {
            if (e instanceof EntityDamageEvent && ((EntityDamageEvent)e).getEntity() == en && !Delay.isDelayed(e)) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        en.setFireTicks(d);
                    }
                });
                continue;
            }
            if (e instanceof EntityCombustEvent && ((EntityCombustEvent)e).getEntity() == en && !Delay.isDelayed(e)) {
                ((EntityCombustEvent)e).setCancelled(true);
            }
            en.setFireTicks(d);
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (this.ignite) {
            return "set " + this.entities.toString(e, debug) + " on fire for " + (this.duration != null ? this.duration.toString(e, debug) : Timespan.fromTicks(160).toString());
        }
        return "extinguish " + this.entities.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffIgnite.class, "(ignite|set fire to) %entities% [for %-timespan%]", "(set|light) %entities% on fire [for %-timespan%]", "extinguish %entities%");
    }
}

