/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.ExprColoured;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.util.chat.BungeeConverter;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.skript.util.chat.MessageComponent;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Message")
@Description(value={"Sends a message to the given player. Only styles written", "in given string or in <a href=expressions.html#ExprColoured>formatted expressions</a> will be parsed.", "Adding an optional sender allows the messages to be sent as if a specific player sent them.", "This is useful with Minecraft 1.16.4's new chat ignore system, in which players can choose to ignore other players,", "but for this to work, the message needs to be sent from a player."})
@Examples(value={"message \"A wild %player% appeared!\"", "message \"This message is a distraction. Mwahaha!\"", "send \"Your kill streak is %{kill streak::%uuid of player%}%.\" to player", "if the targeted entity exists:", "\tmessage \"You're currently looking at a %type of the targeted entity%!\"", "on chat:", "\tcancel event", "\tsend \"[%player%] >> %message%\" to all players from player"})
@RequiredPlugins(value={"Minecraft 1.16.4+ for optional sender"})
@Since(value="1.0, 2.2-dev26 (advanced features), 2.5.2 (optional sender), 2.6 (sending objects)")
public class EffMessage
extends Effect {
    private static final boolean SUPPORTS_SENDER;
    private Expression<?>[] messages;
    private Expression<?> messageExpr;
    private Expression<CommandSender> recipients;
    private @Nullable Expression<Player> sender;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        Expression[] expressionArray;
        this.messageExpr = LiteralUtils.defendExpression(exprs[0]);
        if (this.messageExpr instanceof ExpressionList) {
            expressionArray = ((ExpressionList)this.messageExpr).getExpressions();
        } else {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = this.messageExpr;
        }
        this.messages = expressionArray;
        this.recipients = exprs[1];
        if (SUPPORTS_SENDER) {
            this.sender = exprs[2];
        }
        return LiteralUtils.canInitSafely(this.messageExpr);
    }

    @Override
    protected void execute(Event event) {
        EffMessage.sendMessage(event, this.getMessages(), this.recipients.getArray(event), this.sender != null ? this.sender.getSingle(event) : null);
    }

    public static void sendMessage(Event event, Expression<?>[] messages, CommandSender[] receivers, @Nullable Player sender) {
        for (Expression<?> message : messages) {
            ?[] messageArray = null;
            List<MessageComponent> messageComponents = null;
            for (CommandSender receiver : receivers) {
                if (receiver instanceof Player && message instanceof VariableString) {
                    if (messageComponents == null) {
                        messageComponents = ((VariableString)message).getMessageComponents(event);
                    }
                } else if (messageArray == null) {
                    messageArray = message.getArray(event);
                }
                if (receiver instanceof Player) {
                    if (message instanceof VariableString) {
                        EffMessage.sendMessage((Player)receiver, sender, BungeeConverter.convert(messageComponents));
                        continue;
                    }
                    if (message instanceof ExprColoured && ((ExprColoured)message).isUnsafeFormat()) {
                        for (Object object : messageArray) {
                            EffMessage.sendMessage((Player)receiver, sender, BungeeConverter.convert(ChatMessages.parse((String)object)));
                        }
                        continue;
                    }
                    for (Object object : messageArray) {
                        List<MessageComponent> components = ChatMessages.fromParsedString(EffMessage.toString(object));
                        EffMessage.sendMessage((Player)receiver, sender, BungeeConverter.convert(components));
                    }
                    continue;
                }
                for (Object object : messageArray) {
                    receiver.sendMessage(EffMessage.toString(object));
                }
            }
        }
    }

    private static void sendMessage(Player receiver, @Nullable Player sender, BaseComponent ... components) {
        if (SUPPORTS_SENDER && sender != null) {
            receiver.spigot().sendMessage(sender.getUniqueId(), components);
        } else {
            receiver.spigot().sendMessage(components);
        }
    }

    private Expression<?>[] getMessages() {
        if (this.messageExpr instanceof ExpressionList && !this.messageExpr.getAnd()) {
            return new Expression[]{CollectionUtils.getRandom(this.messages)};
        }
        return this.messages;
    }

    private static String toString(Object object) {
        return object instanceof String ? (String)object : Classes.toString(object);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "send " + this.messageExpr.toString(e, debug) + " to " + this.recipients.toString(e, debug) + (this.sender != null ? " from " + this.sender.toString(e, debug) : "");
    }

    static {
        boolean bl = SUPPORTS_SENDER = Skript.classExists("org.bukkit.command.CommandSender$Spigot") && Skript.methodExists(CommandSender.Spigot.class, "sendMessage", UUID.class, BaseComponent.class);
        if (SUPPORTS_SENDER) {
            Skript.registerEffect(EffMessage.class, "(message|send [message[s]]) %objects% [to %commandsenders%] [from %-player%]");
        } else {
            Skript.registerEffect(EffMessage.class, "(message|send [message[s]]) %objects% [to %commandsenders%]");
        }
    }
}

