/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.PotionEffectUtils;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Potion Effects")
@Description(value={"Apply or remove potion effects to/from entities."})
@Examples(value={"apply swiftness 2 to the player", "remove haste from the victim", "on join:", "\tapply potion of strength of tier {strength.%player%} to the player for 999 days", "apply potion effects of player's tool to player"})
@Since(value="2.0, 2.2-dev27 (ambient and particle-less potion effects), 2.5 (replacing existing effect), 2.5.2 (potion effects)")
public class EffPotion
extends Effect {
    private static final int DEFAULT_DURATION = 300;
    private boolean replaceExisting;
    private Expression<PotionEffectType> potions;
    private @Nullable Expression<Number> tier;
    private Expression<LivingEntity> entities;
    private @Nullable Expression<Timespan> duration;
    private Expression<PotionEffect> potionEffects;
    private boolean apply;
    private boolean ambient;
    private boolean particles;
    private boolean potionEffect;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.apply = matchedPattern > 0;
        this.potionEffect = matchedPattern == 0;
        boolean bl = this.replaceExisting = parseResult.mark == 1;
        if (this.potionEffect) {
            this.potionEffects = exprs[0];
            this.entities = exprs[1];
        } else if (this.apply) {
            this.potions = exprs[0];
            this.tier = exprs[1];
            this.entities = exprs[2];
            this.duration = exprs[3];
        } else {
            this.potions = exprs[0];
            this.entities = exprs[1];
        }
        switch (matchedPattern) {
            case 1: {
                this.ambient = false;
                this.particles = true;
                break;
            }
            case 2: {
                this.ambient = true;
                this.particles = true;
                break;
            }
            case 3: {
                this.ambient = false;
                this.particles = false;
            }
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        if (this.potionEffect) {
            for (LivingEntity livingEntity : this.entities.getArray(e)) {
                Object[] potionEffects = this.potionEffects.getArray(e);
                PotionEffectUtils.addEffects(livingEntity, potionEffects);
            }
        } else {
            PotionEffectType[] ts = this.potions.getArray(e);
            if (ts.length == 0) {
                return;
            }
            if (!this.apply) {
                for (LivingEntity en : this.entities.getArray(e)) {
                    for (PotionEffectType t : ts) {
                        en.removePotionEffect(t);
                    }
                }
                return;
            }
            int a = 0;
            if (this.tier != null) {
                Number amp = this.tier.getSingle(e);
                if (amp == null) {
                    return;
                }
                a = amp.intValue() - 1;
            }
            int d = 300;
            if (this.duration != null) {
                Timespan dur = this.duration.getSingle(e);
                if (dur == null) {
                    return;
                }
                d = (int)(dur.getTicks_i() >= Integer.MAX_VALUE ? Integer.MAX_VALUE : dur.getTicks_i());
            }
            for (LivingEntity en : this.entities.getArray(e)) {
                for (PotionEffectType t : ts) {
                    int duration = d;
                    if (!this.replaceExisting && en.hasPotionEffect(t)) {
                        for (PotionEffect eff : en.getActivePotionEffects()) {
                            if (eff.getType() != t) continue;
                            duration += eff.getDuration();
                            break;
                        }
                    }
                    en.addPotionEffect(new PotionEffect(t, duration, a, this.ambient, this.particles), true);
                }
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (this.potionEffect) {
            return "apply " + this.potionEffects.toString(e, debug) + " to " + this.entities.toString(e, debug);
        }
        if (this.apply) {
            return "apply " + this.potions.toString(e, debug) + (this.tier != null ? " of tier " + this.tier.toString(e, debug) : "") + " to " + this.entities.toString(e, debug) + (this.duration != null ? " for " + this.duration.toString(e, debug) : "");
        }
        return "remove " + this.potions.toString(e, debug) + " from " + this.entities.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffPotion.class, "apply %potioneffects% to %livingentities%", "apply [potion of] %potioneffecttypes% [potion] [[[of] tier] %-number%] to %livingentities% [for %-timespan%] [(1\u00a6replacing [the] existing effect)]", "apply ambient [potion of] %potioneffecttypes% [potion] [[[of] tier] %-number%] to %livingentities% [for %-timespan%] [(1\u00a6replacing [the] existing effect)]", "apply [potion of] %potioneffecttypes% [potion] [[[of] tier] %-number%] without [any] particles to %livingentities% [for %-timespan%] [(1\u00a6replacing [the] existing effect)]");
    }
}

