/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.paperlib.PaperLib;
import ch.njol.skript.paperlib.environments.PaperEnvironment;
import ch.njol.skript.timings.SkriptTimings;
import ch.njol.skript.util.Direction;
import ch.njol.skript.variables.Variables;
import ch.njol.skript.variables.VariablesMap;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Teleport")
@Description(value={"Teleport an entity to a specific location. ", "This effect is delayed by default on Paper, meaning certain syntax such as the return effect for functions cannot be used after this effect.", "The keyword 'force' indicates this effect will not be delayed, ", "which may cause lag spikes or server crashes when using this effect to teleport entities to unloaded chunks."})
@Examples(value={"teleport the player to {homes.%player%}", "teleport the attacker to the victim"})
@Since(value="1.0")
public class EffTeleport
extends Effect {
    private static final boolean CAN_RUN_ASYNC = PaperLib.getEnvironment() instanceof PaperEnvironment;
    private Expression<Entity> entities;
    private Expression<Location> location;
    private boolean isAsync;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.location = Direction.combine(exprs[1], exprs[2]);
        boolean bl = this.isAsync = CAN_RUN_ASYNC && parseResult.mark == 0;
        if (this.isAsync) {
            this.getParser().setHasDelayBefore(Kleenean.UNKNOWN);
        }
        return true;
    }

    @Override
    protected @Nullable TriggerItem walk(Event e) {
        this.debug(e, true);
        TriggerItem next = this.getNext();
        boolean delayed = Delay.isDelayed(e);
        Location loc = this.location.getSingle(e);
        if (loc == null) {
            return next;
        }
        Entity[] entityArray = this.entities.getArray(e);
        if (entityArray.length == 0) {
            return next;
        }
        if (!delayed) {
            if (e instanceof PlayerRespawnEvent && entityArray.length == 1 && entityArray[0].equals(((PlayerRespawnEvent)e).getPlayer())) {
                ((PlayerRespawnEvent)e).setRespawnLocation(loc);
                return next;
            }
            if (e instanceof PlayerMoveEvent && entityArray.length == 1 && entityArray[0].equals(((PlayerMoveEvent)e).getPlayer())) {
                ((PlayerMoveEvent)e).setTo(loc);
                return next;
            }
        }
        if (!this.isAsync) {
            for (Entity entity : entityArray) {
                entity.teleport(loc);
            }
            return next;
        }
        Delay.addDelayedEvent(e);
        VariablesMap localVars = Variables.removeLocals(e);
        PaperLib.getChunkAtAsync(loc).thenAccept(chunk -> {
            for (Entity entity : entityArray) {
                entity.teleport(loc);
            }
            if (localVars != null) {
                Variables.setLocalVariables(e, localVars);
            }
            Object timing = null;
            if (next != null) {
                Trigger trigger;
                if (SkriptTimings.enabled() && (trigger = this.getTrigger()) != null) {
                    timing = SkriptTimings.start(trigger.getDebugLabel());
                }
                TriggerItem.walk(next, e);
            }
            Variables.removeLocals(e);
            SkriptTimings.stop(timing);
        });
        return null;
    }

    @Override
    protected void execute(Event e) {
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "teleport " + this.entities.toString(e, debug) + " to " + this.location.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffTeleport.class, "[(1\u00a6force)] teleport %entities% (to|%direction%) %location%");
    }
}

