/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.VectorMath;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Rotate around XYZ")
@Description(value={"Rotates a vector around x, y, or z axis by some degrees"})
@Examples(value={"rotate {_v} around x-axis by 90", "rotate {_v} around y-axis by 90", "rotate {_v} around z-axis by 90 degrees"})
@Since(value="2.2-dev28")
public class EffVectorRotateXYZ
extends Effect {
    private static final Character[] axes;
    private Expression<Vector> vectors;
    private Expression<Number> degree;
    private int axis;

    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.vectors = expressions[0];
        this.degree = expressions[1];
        this.axis = parseResult.mark;
        return true;
    }

    @Override
    protected void execute(Event e) {
        Number d = this.degree.getSingle(e);
        if (d == null) {
            return;
        }
        switch (this.axis) {
            case 1: {
                for (Vector v : this.vectors.getArray(e)) {
                    VectorMath.rotX(v, d.doubleValue());
                }
                break;
            }
            case 2: {
                for (Vector v : this.vectors.getArray(e)) {
                    VectorMath.rotY(v, d.doubleValue());
                }
                break;
            }
            case 3: {
                for (Vector v : this.vectors.getArray(e)) {
                    VectorMath.rotZ(v, d.doubleValue());
                }
                break;
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "rotate " + this.vectors.toString(e, debug) + " around " + axes[this.axis] + "-axis by " + this.degree + "degrees";
    }

    static {
        Skript.registerEffect(EffVectorRotateXYZ.class, "rotate %vectors% around (1\u00a6x|2\u00a6y|3\u00a6z)(-| )axis by %number% [degrees]");
        axes = new Character[]{Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')};
    }
}

