/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Color;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.DyeColor;
import org.bukkit.entity.TropicalFish;
import org.eclipse.jdt.annotation.Nullable;

public class TropicalFishData
extends EntityData<TropicalFish> {
    private static Object[] patterns;
    private @Nullable DyeColor patternColor;
    private @Nullable DyeColor bodyColor;

    public TropicalFishData() {
        this(0);
    }

    public TropicalFishData(TropicalFish.Pattern pattern) {
        this.matchedPattern = pattern.ordinal() + 1;
    }

    private TropicalFishData(int pattern) {
        this.matchedPattern = pattern;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (exprs.length == 0) {
            return true;
        }
        if (exprs[2] != null) {
            this.patternColor = this.bodyColor = ((Color)exprs[2].getSingle()).asDyeColor();
        }
        if (exprs[0] != null) {
            this.bodyColor = ((Color)exprs[0].getSingle()).asDyeColor();
        }
        if (exprs[1] != null) {
            this.patternColor = ((Color)exprs[1].getSingle()).asDyeColor();
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends TropicalFish> c, @Nullable TropicalFish tropicalFish) {
        if (tropicalFish != null) {
            this.matchedPattern = tropicalFish.getPattern().ordinal() + 1;
            this.bodyColor = tropicalFish.getBodyColor();
            this.patternColor = tropicalFish.getPatternColor();
        }
        return true;
    }

    @Override
    public void set(TropicalFish entity) {
        if (this.matchedPattern == 0) {
            entity.setPattern((TropicalFish.Pattern)patterns[ThreadLocalRandom.current().nextInt(patterns.length)]);
        } else {
            entity.setPattern((TropicalFish.Pattern)patterns[this.matchedPattern]);
        }
        if (this.bodyColor != null) {
            entity.setBodyColor(this.bodyColor);
        }
        if (this.patternColor != null) {
            entity.setPatternColor(this.patternColor);
        }
    }

    @Override
    protected boolean match(TropicalFish entity) {
        boolean sameBody;
        boolean samePattern = this.matchedPattern == 0 || this.matchedPattern == entity.getPattern().ordinal() + 1;
        boolean bl = sameBody = this.bodyColor == null || this.bodyColor == entity.getBodyColor();
        if (this.patternColor == null) {
            return samePattern && sameBody;
        }
        return samePattern && sameBody && this.patternColor == entity.getPatternColor();
    }

    @Override
    public Class<? extends TropicalFish> getType() {
        return TropicalFish.class;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof TropicalFishData)) {
            return false;
        }
        TropicalFishData other = (TropicalFishData)obj;
        return this.matchedPattern == other.matchedPattern && this.bodyColor == other.bodyColor && this.patternColor == other.patternColor;
    }

    @Override
    protected int hashCode_i() {
        return Objects.hash(this.matchedPattern, this.bodyColor, this.patternColor);
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (!(e instanceof TropicalFishData)) {
            return false;
        }
        TropicalFishData other = (TropicalFishData)e;
        return this.matchedPattern == other.matchedPattern && this.bodyColor == other.bodyColor && this.patternColor == other.patternColor;
    }

    @Override
    public EntityData getSuperType() {
        return new TropicalFishData(this.matchedPattern);
    }

    static {
        if (Skript.isRunningMinecraft(1, 13)) {
            TropicalFishData.register(TropicalFishData.class, "tropical fish", TropicalFish.class, 0, "tropical fish", "kob", "sunstreak", "snooper", "dasher", "brinely", "spotty", "flopper", "stripey", "glitter", "blockfish", "betty", "clayfish");
            patterns = TropicalFish.Pattern.values();
        }
    }
}

