/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.ClickEventTracker;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.data.DefaultComparators;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Checker;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.eclipse.jdt.annotation.Nullable;

public class EvtClick
extends SkriptEvent {
    static final boolean twoHanded = Skript.isRunningMinecraft(1, 9);
    static final boolean alwaysPreferItem = !Skript.isRunningMinecraft(1, 13);
    private static final int RIGHT = 1;
    private static final int LEFT = 2;
    private static final int ANY = 3;
    public static final ClickEventTracker interactTracker = new ClickEventTracker(Skript.getInstance());
    private static final ClickEventTracker entityInteractTracker = new ClickEventTracker(Skript.getInstance());
    private @Nullable Literal<?> types = null;
    private @Nullable Literal<ItemType> tools;
    private int click = 3;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.click = parser.mark == 0 ? 3 : parser.mark;
        this.types = args[matchedPattern];
        if (this.types != null && !ItemType.class.isAssignableFrom(this.types.getReturnType())) {
            if (this.click == 2) {
                Skript.error("A leftclick on an entity is an attack and thus not covered by the 'click' event, but the 'damage' event.", ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
            if (this.click == 3) {
                Skript.warning("A leftclick on an entity is an attack and thus not covered by the 'click' event, but the 'damage' event. Change this event to a rightclick to disable this warning message.");
            }
        }
        this.tools = args[1 - matchedPattern];
        return true;
    }

    @Override
    public boolean check(final Event e) {
        Block block;
        Entity entity;
        if (e instanceof PlayerInteractEntityEvent) {
            PlayerInteractEntityEvent clickEvent = (PlayerInteractEntityEvent)e;
            Entity clicked = clickEvent.getRightClicked();
            if (clickEvent instanceof PlayerInteractAtEntityEvent && !(clicked instanceof ArmorStand)) {
                return false;
            }
            if (this.click == 2) {
                return false;
            }
            if (!(e instanceof PlayerInteractAtEntityEvent) && !entityInteractTracker.checkEvent(clickEvent.getPlayer(), (Cancellable)clickEvent, clickEvent.getHand())) {
                return false;
            }
            entity = clicked;
            block = null;
        } else if (e instanceof PlayerInteractEvent) {
            int click;
            PlayerInteractEvent clickEvent = (PlayerInteractEvent)e;
            Action a = clickEvent.getAction();
            switch (a) {
                case LEFT_CLICK_AIR: 
                case LEFT_CLICK_BLOCK: {
                    click = 2;
                    break;
                }
                case RIGHT_CLICK_AIR: 
                case RIGHT_CLICK_BLOCK: {
                    click = 1;
                    break;
                }
                default: {
                    return false;
                }
            }
            if ((this.click & click) == 0) {
                return false;
            }
            EquipmentSlot hand = clickEvent.getHand();
            assert (hand != null);
            if (!interactTracker.checkEvent(clickEvent.getPlayer(), (Cancellable)clickEvent, hand)) {
                return false;
            }
            block = clickEvent.getClickedBlock();
            entity = null;
        } else {
            assert (false);
            return false;
        }
        if (this.tools != null && !this.tools.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(ItemType t) {
                if (e instanceof PlayerInteractEvent) {
                    return t.isOfType(((PlayerInteractEvent)e).getItem());
                }
                PlayerInventory invi = ((PlayerInteractEntityEvent)e).getPlayer().getInventory();
                ItemStack item = ((PlayerInteractEntityEvent)e).getHand() == EquipmentSlot.HAND ? invi.getItemInMainHand() : invi.getItemInOffHand();
                return t.isOfType(item);
            }
        })) {
            return false;
        }
        if (this.types != null) {
            return this.types.check(e, new Checker<Object>(){

                @Override
                public boolean check(Object o) {
                    if (entity != null) {
                        return o instanceof EntityData ? ((EntityData)o).isInstance(entity) : Comparator.Relation.EQUAL.is(DefaultComparators.entityItemComparator.compare(EntityData.fromEntity(entity), (ItemType)o));
                    }
                    return o instanceof EntityData ? false : ((ItemType)o).isOfType(block);
                }
            });
        }
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return (this.click == 2 ? "left" : (this.click == 1 ? "right" : "")) + "click" + (this.types != null ? " on " + this.types.toString(e, debug) : "") + (this.tools != null ? " holding " + this.tools.toString(e, debug) : "");
    }

    static {
        Class[] eventTypes = CollectionUtils.array(PlayerInteractEvent.class, PlayerInteractEntityEvent.class);
        Skript.registerEvent("Click", EvtClick.class, eventTypes, "[(1\u00a6right|2\u00a6left)(| |-)][mouse(| |-)]click[ing] [on %-entitydata/itemtype%] [(with|using|holding) %itemtype%]", "[(1\u00a6right|2\u00a6left)(| |-)][mouse(| |-)]click[ing] (with|using|holding) %itemtype% on %entitydata/itemtype%").description("Called when a user clicks on a block, an entity or air with or without an item in their hand.", "Please note that rightclick events with an empty hand while not looking at a block are not sent to the server, so there's no way to detect them.").examples("on click:", "on rightclick holding a fishing rod:", "on leftclick on a stone or obsidian:", "on rightclick on a creeper:", "on click with a sword:").since("1.0");
    }
}

