/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Color;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.FireworkEffect;
import org.bukkit.event.Event;
import org.bukkit.event.entity.FireworkExplodeEvent;
import org.bukkit.inventory.meta.FireworkMeta;
import org.eclipse.jdt.annotation.Nullable;

public class EvtFirework
extends SkriptEvent {
    private @Nullable Literal<Color> colors;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (args[0] != null) {
            this.colors = args[0];
        }
        return true;
    }

    @Override
    public boolean check(Event e) {
        if (this.colors == null) {
            return true;
        }
        List colours = Arrays.stream((Color[])this.colors.getArray(e)).map(color -> color.asBukkitColor()).collect(Collectors.toList());
        FireworkMeta meta = ((FireworkExplodeEvent)e).getEntity().getFireworkMeta();
        for (FireworkEffect effect : meta.getEffects()) {
            if (!colours.containsAll(effect.getColors())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "Firework explode " + (this.colors != null ? " with colors " + this.colors.toString(e, debug) : "");
    }

    static {
        if (Skript.classExists("org.bukkit.event.entity.FireworkExplodeEvent")) {
            Skript.registerEvent("Firework Explode", EvtFirework.class, FireworkExplodeEvent.class, "[a] firework explo(d(e|ing)|sion) [colo[u]red %-colors%]").description("Called when a firework explodes.").examples("on firework explode", "on firework exploding colored red, light green and black", "on firework explosion coloured light green:", "\tbroadcast \"A firework colored %colors% was exploded at %location%!\"").since("2.4");
        }
    }
}

