/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.sections.EffSecSpawn;
import ch.njol.util.Checker;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.eclipse.jdt.annotation.Nullable;

public class EvtItem
extends SkriptEvent {
    private static final boolean hasConsumeEvent = Skript.classExists("org.bukkit.event.player.PlayerItemConsumeEvent");
    private static final boolean hasPrepareCraftEvent = Skript.classExists("org.bukkit.event.inventory.PrepareItemCraftEvent");
    private static final boolean hasEntityPickupItemEvent = Skript.classExists("org.bukkit.event.entity.EntityPickupItemEvent");
    private @Nullable Literal<ItemType> types;
    private boolean entity;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.types = args[0];
        this.entity = parser.mark == 1;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean check(Event e) {
        ItemStack is;
        if (e instanceof ItemSpawnEvent) {
            EffSecSpawn.lastSpawned = ((ItemSpawnEvent)e).getEntity();
        }
        if (hasEntityPickupItemEvent && (!this.entity && e instanceof EntityPickupItemEvent || this.entity && e instanceof PlayerPickupItemEvent)) {
            return false;
        }
        if (this.types == null) {
            return true;
        }
        if (e instanceof BlockDispenseEvent) {
            is = ((BlockDispenseEvent)e).getItem();
        } else if (e instanceof ItemSpawnEvent) {
            is = ((ItemSpawnEvent)e).getEntity().getItemStack();
        } else if (e instanceof PlayerDropItemEvent) {
            is = ((PlayerDropItemEvent)e).getItemDrop().getItemStack();
        } else if (e instanceof CraftItemEvent) {
            is = ((CraftItemEvent)e).getRecipe().getResult();
        } else if (hasPrepareCraftEvent && e instanceof PrepareItemCraftEvent) {
            PrepareItemCraftEvent event = (PrepareItemCraftEvent)e;
            Recipe recipe = event.getRecipe();
            if (recipe == null) return false;
            is = recipe.getResult();
        } else if (e instanceof EntityPickupItemEvent) {
            is = ((EntityPickupItemEvent)e).getItem().getItemStack();
        } else if (e instanceof PlayerPickupItemEvent) {
            is = ((PlayerPickupItemEvent)e).getItem().getItemStack();
        } else if (hasConsumeEvent && e instanceof PlayerItemConsumeEvent) {
            is = ((PlayerItemConsumeEvent)e).getItem();
        } else if (e instanceof InventoryClickEvent) {
            is = ((InventoryClickEvent)e).getCurrentItem();
        } else if (e instanceof ItemDespawnEvent) {
            is = ((ItemDespawnEvent)e).getEntity().getItemStack();
        } else if (e instanceof ItemMergeEvent) {
            is = ((ItemMergeEvent)e).getTarget().getItemStack();
        } else {
            assert (false);
            return false;
        }
        if (is != null) return this.types.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(ItemType t) {
                return t.isOfType(is);
            }
        });
        return false;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "dispense/spawn/drop/craft/pickup/consume/break/despawn/merge" + (this.types == null ? "" : " of " + this.types);
    }

    static {
        Skript.registerEvent("Dispense", EvtItem.class, BlockDispenseEvent.class, "dispens(e|ing) [[of] %itemtypes%]").description("Called when a dispenser dispenses an item.").examples("on dispense of iron block:", "\tsend \"that'd be 19.99 please!\"").since("<i>unknown</i> (before 2.1)");
        Skript.registerEvent("Item Spawn", EvtItem.class, ItemSpawnEvent.class, "item spawn[ing] [[of] %itemtypes%]").description("Called whenever an item stack is spawned in a world, e.g. as drop of a block or mob, a player throwing items out of their inventory, or a dispenser dispensing an item (not shooting it).").examples("on item spawn of iron sword:", "\tbroadcast \"Someone dropped an iron sword!\"").since("<i>unknown</i> (before 2.1)");
        Skript.registerEvent("Drop", EvtItem.class, PlayerDropItemEvent.class, "[player] drop[ing] [[of] %itemtypes%]").description("Called when a player drops an item from their inventory.").examples("on drop:").since("<i>unknown</i> (before 2.1)");
        if (hasPrepareCraftEvent) {
            Skript.registerEvent("Prepare Craft", EvtItem.class, PrepareItemCraftEvent.class, "[player] (preparing|beginning) craft[ing] [[of] %itemtypes%]").description("Called just before displaying crafting result to player. Note that setting the result item might or might not work due to Bukkit bugs.").examples("on preparing craft of torch:").since("2.2-Fixes-V10");
        }
        Skript.registerEvent("Craft", EvtItem.class, CraftItemEvent.class, "[player] craft[ing] [[of] %itemtypes%]").description("Called when a player crafts an item.").examples("on craft:").since("<i>unknown</i> (before 2.1)");
        if (hasEntityPickupItemEvent) {
            Skript.registerEvent("Pick Up", EvtItem.class, CollectionUtils.array(PlayerPickupItemEvent.class, EntityPickupItemEvent.class), "[(player|1\u00a6entity)] (pick[ ]up|picking up) [[of] %itemtypes%]").description("Called when a player/entity picks up an item. Please note that the item is still on the ground when this event is called.").examples("on pick up:", "on entity pickup of wheat:").since("<i>unknown</i> (before 2.1), 2.5 (entity)").requiredPlugins("1.12.2+ for entity");
        } else {
            Skript.registerEvent("Pick Up", EvtItem.class, PlayerPickupItemEvent.class, "[player] (pick[ ]up|picking up) [[of] %itemtypes%]").description("Called when a player picks up an item. Please note that the item is still on the ground when this event is called.").examples("on pick up:").since("<i>unknown</i> (before 2.1)");
        }
        if (hasConsumeEvent) {
            Skript.registerEvent("Consume", EvtItem.class, PlayerItemConsumeEvent.class, "[player] ((eat|drink)[ing]|consum(e|ing)) [[of] %itemtypes%]").description("Called when a player is done eating/drinking something, e.g. an apple, bread, meat, milk or a potion.").examples("on consume:").since("2.0");
        }
        Skript.registerEvent("Inventory Click", EvtItem.class, InventoryClickEvent.class, "[player] inventory(-| )click[ing] [[at] %itemtypes%]").description("Called when clicking on inventory slot.").examples("on inventory click:", "\tif event-item is stone:", "\t\tgive player 1 stone", "\t\tremove 20$ from player's balance").since("2.2-Fixes-V10");
        Skript.registerEvent("Item Despawn", EvtItem.class, ItemDespawnEvent.class, "(item[ ][stack]|[item] %-itemtypes%) despawn[ing]", "[item[ ][stack]] despawn[ing] [[of] %-itemtypes%]").description("Called when an item is about to be despawned from the world, usually 5 minutes after it was dropped.").examples("on item despawn of diamond:", "\tsend \"Not my precious!\"", "\tcancel event").since("2.2-dev35");
        Skript.registerEvent("Item Merge", EvtItem.class, ItemMergeEvent.class, "(item[ ][stack]|[item] %-itemtypes%) merg(e|ing)", "item[ ][stack] merg(e|ing) [[of] %-itemtypes%]").description("Called when dropped items merge into a single stack. event-entity will be the entity which is trying to merge, and future event-entity will be the entity which is being merged into.").examples("on item merge of gold blocks:", "\tcancel event").since("2.2-dev35");
    }
}

