/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.events.bukkit.ScriptEvent;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class EvtScript
extends SelfRegisteringSkriptEvent {
    private boolean asyncAllowed;
    private boolean load;
    private @Nullable Trigger t;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.asyncAllowed = parser.mark == 1;
        this.load = matchedPattern == 0;
        return true;
    }

    @Override
    public void register(Trigger t) {
        this.t = t;
        if (this.load) {
            this.runTrigger(t, new ScriptEvent());
        }
    }

    @Override
    public void unregister(Trigger t) {
        assert (t == this.t);
        if (!this.load) {
            this.runTrigger(t, new ScriptEvent());
        }
        this.t = null;
    }

    @Override
    public void unregisterAll() {
        if (!this.load && this.t != null) {
            this.runTrigger(this.t, new ScriptEvent());
        }
        this.t = null;
    }

    private void runTrigger(Trigger trigger, Event event) {
        if (this.asyncAllowed || Bukkit.isPrimaryThread()) {
            trigger.execute(event);
        } else if (Skript.getInstance().isEnabled()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), () -> trigger.execute(event));
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return (this.asyncAllowed ? "async " : "") + "script " + (this.load ? "" : "un") + "load";
    }

    static {
        Skript.registerEvent("Script Load/Unload", EvtScript.class, ScriptEvent.class, "[(1\u00a6async)] [script] (load|init|enable)", "[(1\u00a6async)] [script] (unload|stop|disable)").description("Called directly after the trigger is loaded, or directly before the whole script is unloaded.", "The keyword 'async' indicates the trigger can be ran asynchronously, ").examples("on load:", "\tset {running::%script%} to true", "on unload:", "\tset {running::%script%} to false").since("2.0");
    }
}

