/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Iterator;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Affected Entities")
@Description(value={"The affected entities in the <a href='events.html#aoe_cloud_effect'>area cloud effect</a> event."})
@Examples(value={"on area cloud effect:", "\tloop affected entities:", "\t\tif loop-value is a player:", "\t\t\tsend \"WARNING: you've step on an area effect cloud!\" to loop-value"})
@Since(value="2.4")
public class ExprAffectedEntities
extends SimpleExpression<LivingEntity> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)AreaEffectCloudApplyEvent.class)) {
            Skript.error("The 'affected entities' expression may only be used in an area cloud effect event.");
            return false;
        }
        return true;
    }

    protected @Nullable LivingEntity[] get(Event e) {
        if (e instanceof AreaEffectCloudApplyEvent) {
            return ((AreaEffectCloudApplyEvent)e).getAffectedEntities().toArray(new LivingEntity[0]);
        }
        return null;
    }

    @Override
    public @Nullable Iterator<? extends LivingEntity> iterator(Event e) {
        if (e instanceof AreaEffectCloudApplyEvent) {
            return ((AreaEffectCloudApplyEvent)e).getAffectedEntities().iterator();
        }
        return super.iterator(e);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public Class<? extends LivingEntity> getReturnType() {
        return LivingEntity.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the affected entities";
    }

    static {
        Skript.registerExpression(ExprAffectedEntities.class, LivingEntity.class, ExpressionType.SIMPLE, "[the] affected entities");
    }
}

