/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.Location;

@Name(value="Altitude")
@Description(value={"Effectively an alias of 'y-<a href='#ExprCoordinate'>coordinate</a> of \u2026', it represents the height of some object above bedrock."})
@Examples(value={"on damage:", "\taltitude of the attacker is higher than the altitude of the victim", "\tset damage to damage * 1.2"})
@Since(value="1.4.3")
public class ExprAltitude
extends SimplePropertyExpression<Location, Number> {
    @Override
    public Number convert(Location l) {
        return l.getY();
    }

    @Override
    protected String getPropertyName() {
        return "altitude";
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprAltitude.register(ExprAltitude.class, Number.class, "altitude[s]", "locations");
    }
}

