/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Arithmetic;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.conditions.CondCompare;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.DefaultClasses;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Difference")
@Description(value={"The difference between two values, e.g. <a href='../classes.html#number'>numbers</a>, <a href='../classes/#date'>dates</a> or <a href='../classes/#time'>times</a>."})
@Examples(value={"if difference between {command::%player%::lastuse} and now is smaller than a minute:", "\tmessage \"You have to wait a minute before using this command again!\""})
@Since(value="1.4")
public class ExprDifference
extends SimpleExpression<Object> {
    private Expression<?> first;
    private Expression<?> second;
    private @Nullable Arithmetic math;
    private Class<?> relativeType;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        ClassInfo<Object> ci;
        this.first = exprs[0];
        this.second = exprs[1];
        if (this.first instanceof Variable && this.second instanceof Variable) {
            ci = DefaultClasses.OBJECT;
        } else if (this.first instanceof Literal && this.second instanceof Literal) {
            this.first = this.first.getConvertedExpression(Object.class);
            this.second = this.second.getConvertedExpression(Object.class);
            if (this.first == null || this.second == null) {
                return false;
            }
            ci = Classes.getSuperClassInfo(Utils.getSuperType(this.first.getReturnType(), this.second.getReturnType()));
        } else {
            if (this.first instanceof Literal) {
                this.first = this.first.getConvertedExpression(this.second.getReturnType());
                if (this.first == null) {
                    return false;
                }
            } else if (this.second instanceof Literal) {
                this.second = this.second.getConvertedExpression(this.first.getReturnType());
                if (this.second == null) {
                    return false;
                }
            }
            if (this.first instanceof Variable) {
                this.first = this.first.getConvertedExpression(this.second.getReturnType());
            } else if (this.second instanceof Variable) {
                this.second = this.second.getConvertedExpression(this.first.getReturnType());
            }
            assert (this.first != null && this.second != null);
            ci = Classes.getSuperClassInfo(Utils.getSuperType(this.first.getReturnType(), this.second.getReturnType()));
        }
        assert (ci != null);
        if (!ci.getC().equals(Object.class) && ci.getMath() == null) {
            Skript.error("Can't get the difference of " + CondCompare.f(this.first) + " and " + CondCompare.f(this.second), ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        if (ci.getC().equals(Object.class)) {
            this.relativeType = Object.class;
        } else {
            this.math = ci.getMath();
            this.relativeType = ci.getMathRelativeType();
        }
        return true;
    }

    @Override
    protected @Nullable Object[] get(Event e) {
        Object f = this.first.getSingle(e);
        Object s = this.second.getSingle(e);
        if (f == null || s == null) {
            return null;
        }
        Object[] one = (Object[])Array.newInstance(this.relativeType, 1);
        if (this.relativeType.equals(Object.class)) {
            ClassInfo<?> info = Classes.getSuperClassInfo(Utils.getSuperType(f.getClass(), s.getClass()));
            this.math = info.getMath();
            if (this.math == null) {
                return one;
            }
        }
        assert (this.math != null);
        one[0] = this.math.difference(f, s);
        return one;
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.relativeType;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "difference between " + this.first.toString(e, debug) + " and " + this.second.toString(e, debug);
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    static {
        Skript.registerExpression(ExprDifference.class, Object.class, ExpressionType.COMBINED, "difference (between|of) %object% and %object%");
    }
}

