/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.Experience;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.IteratorIterable;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Drops")
@Description(value={"Only works in death events. Holds the drops of the dying creature. Drops can be prevented by removing them with \"remove ... from drops\", e.g. \"remove all pickaxes from the drops\", or \"clear drops\" if you don't want any drops at all."})
@Examples(value={"clear drops", "remove 4 planks from the drops"})
@Since(value="1.0")
@Events(value={"death"})
public class ExprDrops
extends SimpleExpression<ItemType> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)EntityDeathEvent.class)) {
            Skript.error("The expression 'drops' can only be used in death events", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    protected @Nullable ItemType[] get(Event e) {
        return (ItemType[])((EntityDeathEvent)e).getDrops().stream().map(ItemType::new).toArray(ItemType[]::new);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.getParser().getHasDelayBefore().isTrue()) {
            Skript.error("Can't change the drops anymore after the event has already passed");
            return null;
        }
        switch (mode) {
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: 
            case SET: {
                return CollectionUtils.array(ItemType[].class, Inventory[].class, Experience[].class);
            }
        }
        assert (false);
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        List drops = ((EntityDeathEvent)e).getDrops();
        assert (delta != null);
        block6: for (Object o : delta) {
            if (o instanceof Experience) {
                if (mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.REMOVE && ((Experience)o).getInternalXP() == -1) {
                    ((EntityDeathEvent)e).setDroppedExp(0);
                    continue;
                }
                if (mode == Changer.ChangeMode.SET) {
                    ((EntityDeathEvent)e).setDroppedExp(((Experience)o).getXP());
                    continue;
                }
                ((EntityDeathEvent)e).setDroppedExp(Math.max(0, ((EntityDeathEvent)e).getDroppedExp() + (mode == Changer.ChangeMode.ADD ? 1 : -1) * ((Experience)o).getXP()));
                continue;
            }
            switch (mode) {
                case SET: {
                    drops.clear();
                }
                case ADD: {
                    if (o instanceof Inventory) {
                        for (ItemStack is : new IteratorIterable(((Inventory)o).iterator())) {
                            if (is == null) continue;
                            drops.add(is);
                        }
                        continue block6;
                    }
                    ((ItemType)o).addTo(drops);
                    continue block6;
                }
                case REMOVE: 
                case REMOVE_ALL: {
                    if (o instanceof Inventory) {
                        for (ItemStack is : new IteratorIterable(((Inventory)o).iterator())) {
                            if (is == null) continue;
                            if (mode == Changer.ChangeMode.REMOVE) {
                                new ItemType(is).removeFrom(drops);
                                continue;
                            }
                            new ItemType(is).removeAll(drops);
                        }
                        continue block6;
                    }
                    if (mode == Changer.ChangeMode.REMOVE) {
                        ((ItemType)o).removeFrom(drops);
                        continue block6;
                    }
                    ((ItemType)o).removeAll(drops);
                    continue block6;
                }
                case DELETE: 
                case RESET: {
                    assert (false);
                    continue block6;
                }
            }
        }
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the drops";
    }

    static {
        Skript.registerExpression(ExprDrops.class, ItemType.class, ExpressionType.SIMPLE, "[the] drops");
    }
}

