/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Element of")
@Description(value={"The first, last or a random element of a set, e.g. a list variable.", "See also: <a href='#ExprRandom'>random</a>"})
@Examples(value={"give a random element out of {free items::*} to the player"})
@Since(value="2.0")
public class ExprElement
extends SimpleExpression<Object> {
    private int element;
    private Expression<?> expr;
    private @Nullable Expression<Number> number;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.expr = LiteralUtils.defendExpression(exprs[1]);
        this.number = exprs[0];
        this.element = parseResult.mark;
        return LiteralUtils.canInitSafely(this.expr);
    }

    @Override
    protected @Nullable Object[] get(Event e) {
        Object o;
        ?[] os = this.expr.getArray(e);
        if (os.length == 0) {
            return null;
        }
        if (this.element == -1) {
            o = os[0];
        } else if (this.element == 1) {
            o = os[os.length - 1];
        } else if (this.element == 2) {
            Number number = this.number.getSingle(e);
            if (number == null || number.intValue() - 1 >= os.length || number.intValue() - 1 < 0) {
                return null;
            }
            o = os[number.intValue() - 1];
        } else {
            o = CollectionUtils.getRandom(os);
        }
        Object[] r = (Object[])Array.newInstance(this.getReturnType(), 1);
        r[0] = o;
        return r;
    }

    @Override
    public <R> @Nullable Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        Expression<R> convExpr = this.expr.getConvertedExpression(to);
        if (convExpr == null) {
            return null;
        }
        ExprElement exprElement = new ExprElement();
        exprElement.element = this.element;
        exprElement.expr = convExpr;
        exprElement.number = this.number;
        return exprElement;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<?> getReturnType() {
        return this.expr.getReturnType();
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        String prefix;
        switch (this.element) {
            case -1: {
                prefix = "the first";
                break;
            }
            case 1: {
                prefix = "the last";
                break;
            }
            case 0: {
                prefix = "a random";
                break;
            }
            case 2: {
                assert (this.number != null);
                prefix = "the ";
                if (this.number instanceof Literal) {
                    Number number = (Number)((Literal)this.number).getSingle();
                    if (number == null) {
                        prefix = prefix + this.number.toString(e, debug) + "th";
                        break;
                    }
                    prefix = prefix + StringUtils.fancyOrderNumber(number.intValue());
                    break;
                }
                prefix = prefix + this.number.toString(e, debug) + "th";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return prefix + " element of " + this.expr.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprElement.class, Object.class, ExpressionType.PROPERTY, "(-1\u00a6[the] first|1\u00a6[the] last|0\u00a6[a] random|2\u00a6%-number%(st|nd|rd|th)) element [out] of %objects%");
    }
}

