/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.Experience;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Enchantment Experience Level Costs")
@Description(value={"The experience cost of an enchantment in an enchant prepare event.", " If the cost is changed, it will always be at least 1."})
@Examples(value={"on enchant prepare:", "\tset the cost of enchantment 1 to 50"})
@Since(value="2.5")
@Events(value={"enchant prepare"})
@RequiredPlugins(value={"1.9 or 1.10"})
public class ExprEnchantmentExpCosts
extends SimpleExpression<Long> {
    private Expression<Number> exprOfferNumber;
    private boolean multiple;
    static final /* synthetic */ boolean $assertionsDisabled;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)PrepareItemEnchantEvent.class)) {
            Skript.error("The enchantment exp level cost is only usable in an enchant prepare event.", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        if (matchedPattern == 0) {
            this.multiple = true;
        } else {
            this.exprOfferNumber = exprs[0];
            this.multiple = false;
        }
        return true;
    }

    protected @Nullable Long[] get(Event event) {
        PrepareItemEnchantEvent e = (PrepareItemEnchantEvent)event;
        if (this.multiple) {
            return (Long[])Arrays.stream(e.getExpLevelCostsOffered()).boxed().toArray(Long[]::new);
        }
        Number offerNumber = this.exprOfferNumber.getSingle((Event)e);
        if (offerNumber == null) {
            return new Long[0];
        }
        int offer = offerNumber.intValue();
        if (offer < 1 || offer > e.getExpLevelCostsOffered().length) {
            return new Long[0];
        }
        return new Long[]{e.getExpLevelCostsOffered()[offer - 1]};
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.REMOVE_ALL) {
            return null;
        }
        return CollectionUtils.array(Number.class, Experience.class);
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Number offerNumber;
        int cost;
        if (delta == null) {
            return;
        }
        Object c = delta[0];
        int n = cost = c instanceof Number ? ((Number)c).intValue() : ((Experience)c).getXP();
        if (cost < 1) {
            return;
        }
        int offer = 0;
        if (this.exprOfferNumber != null && (offerNumber = this.exprOfferNumber.getSingle(event)) != null) {
            offer = offerNumber.intValue() - 1;
        }
        PrepareItemEnchantEvent e = (PrepareItemEnchantEvent)event;
        switch (mode) {
            case SET: {
                if (this.multiple) {
                    for (int i = 0; i <= 2; ++i) {
                        e.getExpLevelCostsOffered()[i] = cost;
                    }
                    break;
                }
                e.getExpLevelCostsOffered()[offer] = cost;
                break;
            }
            case ADD: {
                if (this.multiple) {
                    for (int i = 0; i <= 2; ++i) {
                        int add = cost + e.getExpLevelCostsOffered()[i];
                        if (add < 1) continue;
                        e.getExpLevelCostsOffered()[i] = add;
                    }
                    break;
                }
                int add = cost + e.getExpLevelCostsOffered()[offer];
                if (add < 1) {
                    return;
                }
                e.getExpLevelCostsOffered()[offer] = add;
                break;
            }
            case REMOVE: {
                if (this.multiple) {
                    for (int i = 0; i <= 2; ++i) {
                        int remove = cost - e.getExpLevelCostsOffered()[i];
                        if (remove < 1) continue;
                        e.getExpLevelCostsOffered()[i] = remove;
                    }
                    break;
                }
                int remove = cost - e.getExpLevelCostsOffered()[offer];
                if (remove < 1) {
                    return;
                }
                e.getExpLevelCostsOffered()[offer] = remove;
                break;
            }
            case RESET: 
            case DELETE: 
            case REMOVE_ALL: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    @Override
    public boolean isSingle() {
        return !this.multiple;
    }

    @Override
    public Class<? extends Long> getReturnType() {
        return Long.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.multiple ? "cost of enchantment offers" : "cost of enchantment offer " + this.exprOfferNumber.toString(e, debug);
    }

    static {
        boolean bl = $assertionsDisabled = !ExprEnchantmentExpCosts.class.desiredAssertionStatus();
        if (!Skript.isRunningMinecraft(1, 11)) {
            Skript.registerExpression(ExprEnchantmentExpCosts.class, Long.class, ExpressionType.SIMPLE, "[the] cost of (enchant[ment]s|enchant[ment] offers)", "[the] cost of enchant[ment] [offer] %number%", "enchant[ment] [offer] %number%'[s] cost", "[the] cost of [the] %number%(st|nd|rd|th) enchant[ment] [offer]");
        }
    }
}

