/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.events.bukkit.ExperienceSpawnEvent;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Experience;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Experience")
@Description(value={"How much experience was spawned in an experience spawn or block break event. Can be changed."})
@Examples(value={"on experience spawn:", "\tadd 5 to the spawned experience", "on break of coal ore:", "\tclear dropped experience", "on break of diamond ore:", "\tif tool of player = diamond pickaxe:", "\t\tadd 100 to dropped experience"})
@Since(value="2.1, 2.5.3 (block break event)")
@Events(value={"experience spawn", "break / mine"})
public class ExprExperience
extends SimpleExpression<Experience> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(ExperienceSpawnEvent.class, BlockBreakEvent.class)) {
            Skript.error("The experience expression can only be used in experience spawn and block break events");
            return false;
        }
        return true;
    }

    protected @Nullable Experience[] get(Event e) {
        if (e instanceof ExperienceSpawnEvent) {
            return new Experience[]{new Experience(((ExperienceSpawnEvent)e).getSpawnedXP())};
        }
        if (e instanceof BlockBreakEvent) {
            return new Experience[]{new Experience(((BlockBreakEvent)e).getExpToDrop())};
        }
        return new Experience[0];
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case ADD: 
            case DELETE: 
            case REMOVE: 
            case REMOVE_ALL: {
                return new Class[]{Experience[].class, Number[].class};
            }
            case SET: {
                return new Class[]{Experience.class, Number.class};
            }
            case RESET: {
                return null;
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        double d;
        if (e instanceof ExperienceSpawnEvent) {
            d = ((ExperienceSpawnEvent)e).getSpawnedXP();
        } else if (e instanceof BlockBreakEvent) {
            d = ((BlockBreakEvent)e).getExpToDrop();
        } else {
            return;
        }
        if (delta != null) {
            block6: for (Object o : delta) {
                double v = o instanceof Experience ? (double)((Experience)o).getXP() : ((Number)o).doubleValue();
                switch (mode) {
                    case ADD: {
                        d += v;
                        continue block6;
                    }
                    case SET: {
                        d = v;
                        continue block6;
                    }
                    case REMOVE: 
                    case REMOVE_ALL: {
                        d -= v;
                        continue block6;
                    }
                    case DELETE: 
                    case RESET: {
                        assert (false);
                        continue block6;
                    }
                }
            }
        } else {
            d = 0.0;
        }
        d = Math.max(0L, Math.round(d));
        if (e instanceof ExperienceSpawnEvent) {
            ((ExperienceSpawnEvent)e).setSpawnedXP((int)d);
        } else {
            ((BlockBreakEvent)e).setExpToDrop((int)d);
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Experience> getReturnType() {
        return Experience.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the experience";
    }

    static {
        Skript.registerExpression(ExprExperience.class, Experience.class, ExpressionType.SIMPLE, "[the] (spawned|dropped|) [e]xp[erience] [orb[s]]");
    }
}

