/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.slot.InventorySlot;
import ch.njol.skript.util.slot.Slot;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Hotbar Slot")
@Description(value={"The slot number of the currently selected hotbar slot."})
@Examples(value={"message \"%player's current hotbar slot%\"", "set player's selected hotbar slot to slot 4 of player"})
@Since(value="2.2-dev36")
public class ExprHotbarSlot
extends SimplePropertyExpression<Player, Slot> {
    @Override
    public @Nullable Slot convert(Player p) {
        PlayerInventory invi = p.getInventory();
        assert (invi != null);
        return new InventorySlot((Inventory)invi, invi.getHeldItemSlot());
    }

    @Override
    protected String getPropertyName() {
        return "hotbar slot";
    }

    @Override
    public Class<? extends Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{Slot.class};
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (delta != null);
        Slot slot = (Slot)delta[0];
        if (!(slot instanceof InventorySlot)) {
            return;
        }
        int index = ((InventorySlot)slot).getIndex();
        if (index > 8) {
            return;
        }
        for (Player p : (Player[])this.getExpr().getArray(e)) {
            p.getInventory().setHeldItemSlot(index);
        }
    }

    static {
        ExprHotbarSlot.register(ExprHotbarSlot.class, Slot.class, "[([currently] selected|current)] hotbar slot", "players");
    }
}

