/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Inventory Holder/Viewers/Rows/Slots")
@Description(value={"Gets the amount of rows/slots, viewers and holder of an inventory.NOTE: 'Viewers' expression returns a list of players viewing the inventory. Note that a player is considered to be viewing their own inventory and internal crafting screen even when said inventory is not open."})
@Examples(value={"event-inventory's amount of rows", "holder of player's top inventory", "{_inventory}'s viewers"})
@Since(value="2.2-dev34, 2.5 (slots)")
public class ExprInventoryInfo
extends SimpleExpression<Object> {
    private static final int HOLDER = 1;
    private static final int VIEWERS = 2;
    private static final int ROWS = 3;
    private static final int SLOTS = 4;
    private Expression<Inventory> inventories;
    private int type;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.inventories = exprs[0];
        this.type = parseResult.mark;
        return true;
    }

    @Override
    protected Object[] get(Event e) {
        Inventory[] inventories = this.inventories.getArray(e);
        ArrayList<Object> objects = new ArrayList<Object>();
        switch (this.type) {
            case 1: {
                for (Inventory inventory : inventories) {
                    InventoryHolder holder = inventory.getHolder();
                    if (holder == null) continue;
                    objects.add(holder);
                }
                break;
            }
            case 3: {
                for (Inventory inventory : inventories) {
                    int size = inventory.getSize();
                    if (size < 9) {
                        objects.add(1);
                        continue;
                    }
                    objects.add(size / 9);
                }
                break;
            }
            case 4: {
                for (Inventory inventory : inventories) {
                    objects.add(inventory.getSize());
                }
                break;
            }
            case 2: {
                for (Inventory inventory : inventories) {
                    objects.addAll(inventory.getViewers());
                }
                break;
            }
            default: {
                return new Object[0];
            }
        }
        return objects.toArray(new Object[0]);
    }

    @Override
    public boolean isSingle() {
        return this.inventories.isSingle() && this.type != 2;
    }

    @Override
    public Class<?> getReturnType() {
        return this.type == 1 ? InventoryHolder.class : (this.type == 3 || this.type == 4 ? Number.class : Player.class);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return (this.type == 1 ? "holder of " : (this.type == 3 ? "rows of " : (this.type == 4 ? "slots of " : "viewers of "))) + this.inventories.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprInventoryInfo.class, Object.class, ExpressionType.PROPERTY, "(1\u00a6holder[s]|2\u00a6viewers|3\u00a6[amount of] rows|4\u00a6[amount of] slots) of %inventories%", "%inventories%'[s] (1\u00a6holder[s]|2\u00a6viewers|3\u00a6[amount of] rows|4\u00a6[amount of] slots)");
    }
}

