/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Projectile Bounce State")
@Description(value={"A projectile's bounce state."})
@Examples(value={"on projectile hit:", "\tset projectile bounce mode of event-projectile to true"})
@Since(value="2.5.1")
public class ExprProjectileBounceState
extends SimplePropertyExpression<Projectile, Boolean> {
    @Override
    public @Nullable Boolean convert(Projectile projectile) {
        return projectile.doesBounce();
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET ? CollectionUtils.array(Boolean.class) : null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        boolean state = (Boolean)delta[0];
        for (Projectile entity : (Projectile[])this.getExpr().getArray(e)) {
            entity.setBounce(state);
        }
    }

    @Override
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @Override
    protected String getPropertyName() {
        return "projectile bounce state";
    }

    static {
        ExprProjectileBounceState.register(ExprProjectileBounceState.class, Boolean.class, "projectile bounce (state|ability|mode)", "projectiles");
    }
}

