/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Remaining Air")
@Description(value={"How much time a player has left underwater before starting to drown."})
@Examples(value={"player's remaining air is less than 3 seconds:", "\tsend \"hurry, get to the surface!\" to the player"})
@Since(value="<i>unknown</i> (before 2.1)")
public class ExprRemainingAir
extends SimplePropertyExpression<LivingEntity, Timespan> {
    @Override
    public Class<Timespan> getReturnType() {
        return Timespan.class;
    }

    @Override
    protected String getPropertyName() {
        return "remaining air";
    }

    @Override
    public Timespan convert(LivingEntity entity) {
        return Timespan.fromTicks_i(entity.getRemainingAir());
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode != Changer.ChangeMode.REMOVE_ALL ? CollectionUtils.array(Timespan.class) : null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case ADD: {
                long ticks = ((Timespan)delta[0]).getTicks_i();
                for (LivingEntity entity : (LivingEntity[])this.getExpr().getArray(event)) {
                    int newTicks = entity.getRemainingAir() + (int)ticks;
                    if (newTicks > 20000) {
                        newTicks = 20000;
                    }
                    entity.setRemainingAir(newTicks);
                }
                break;
            }
            case REMOVE: {
                long ticks = ((Timespan)delta[0]).getTicks_i();
                for (LivingEntity entity : (LivingEntity[])this.getExpr().getArray(event)) {
                    entity.setRemainingAir(entity.getRemainingAir() - (int)ticks);
                }
                break;
            }
            case SET: {
                long ticks = ((Timespan)delta[0]).getTicks_i();
                if (ticks > 20000L) {
                    ticks = 20000L;
                }
                for (LivingEntity entity : (LivingEntity[])this.getExpr().getArray(event)) {
                    entity.setRemainingAir((int)ticks);
                }
                break;
            }
            case DELETE: 
            case REMOVE_ALL: 
            case RESET: {
                for (LivingEntity entity : (LivingEntity[])this.getExpr().getArray(event)) {
                    entity.setRemainingAir(300);
                }
                break;
            }
        }
    }

    static {
        ExprRemainingAir.register(ExprRemainingAir.class, Timespan.class, "remaining air", "livingentities");
    }
}

