/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Reversed List")
@Description(value={"Reverses given list."})
@Examples(value={"set {_list::*} to reversed {_list::*}"})
@Since(value="2.4")
public class ExprReversedList
extends SimpleExpression<Object> {
    private Expression<?> list;

    public ExprReversedList() {
    }

    public ExprReversedList(Expression<?> list) {
        this.list = list;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.list = LiteralUtils.defendExpression(exprs[0]);
        return LiteralUtils.canInitSafely(this.list);
    }

    @Override
    protected @Nullable Object[] get(Event e) {
        Object[] inputArray = (Object[])this.list.getArray(e).clone();
        Object[] array = (Object[])Array.newInstance(this.getReturnType(), inputArray.length);
        System.arraycopy(inputArray, 0, array, 0, inputArray.length);
        this.reverse(array);
        return array;
    }

    @Override
    public <R> @Nullable Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        if (CollectionUtils.containsSuperclass(to, this.getReturnType())) {
            return this;
        }
        Expression<R> convertedList = this.list.getConvertedExpression(to);
        if (convertedList != null) {
            return new ExprReversedList(convertedList);
        }
        return null;
    }

    private void reverse(Object[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            Object temp = array[i];
            int reverse = array.length - i - 1;
            array[i] = array[reverse];
            array[reverse] = temp;
        }
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<?> getReturnType() {
        return this.list.getReturnType();
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "reversed " + this.list.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprReversedList.class, Object.class, ExpressionType.COMBINED, "reversed %objects%");
    }
}

