/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Spawner Type")
@Description(value={"Retrieves, sets, or resets the spawner's entity type"})
@Examples(value={"on right click:", "\tif event-block is spawner:", "\t\tsend \"Spawner's type is %target block's entity type%\""})
@Since(value="2.4")
public class ExprSpawnerType
extends SimplePropertyExpression<Block, EntityData> {
    private static final Material MATERIAL_SPAWNER = Aliases.javaItemType("spawner").getMaterial();

    @Override
    public @Nullable EntityData convert(Block b) {
        if (b.getType() != MATERIAL_SPAWNER) {
            return null;
        }
        return EntityUtils.toSkriptEntityData(((CreatureSpawner)b.getState()).getSpawnedType());
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return CollectionUtils.array(EntityData.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        for (Block b : (Block[])this.getExpr().getArray(e)) {
            if (b.getType() != MATERIAL_SPAWNER) continue;
            CreatureSpawner s = (CreatureSpawner)b.getState();
            switch (mode) {
                case SET: {
                    s.setSpawnedType(EntityUtils.toBukkitEntityType((EntityData)delta[0]));
                    break;
                }
                case RESET: {
                    s.setSpawnedType(EntityType.PIG);
                }
            }
            s.update();
        }
    }

    @Override
    public Class<EntityData> getReturnType() {
        return EntityData.class;
    }

    @Override
    protected String getPropertyName() {
        return "entity type";
    }

    static {
        ExprSpawnerType.register(ExprSpawnerType.class, EntityData.class, "(spawner|entity|creature) type[s]", "blocks");
    }
}

