/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Targeted Block")
@Description(value={"The block at the crosshair. This regards all blocks that are not air as fully solid, e.g. torches will be like a solid stone block for this expression."})
@Examples(value={"# A command to set the block a player looks at to a specific type:", "command /setblock &lt;material&gt;:", "\ttrigger:", "\t\tset targeted block to argument"})
@Since(value="1.0")
public class ExprTargetedBlock
extends PropertyExpression<Player, Block> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(exprs[0]);
        if (matchedPattern >= 2) {
            Skript.warning("The 'actual' part of the targeted block expression is deprecated, it is now no longer required");
        }
        return true;
    }

    protected Block[] get(Event e, Player[] source) {
        return this.get(source, p -> {
            Block block = p.getTargetBlock(null, SkriptConfig.maxTargetBlockDistance.value().intValue());
            if (block.getType() == Material.AIR) {
                return null;
            }
            return block;
        });
    }

    @Override
    public Class<Block> getReturnType() {
        return Block.class;
    }

    @Override
    public boolean setTime(int time) {
        super.setTime(time);
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the targeted block" + (this.getExpr().isSingle() ? "" : "s") + " of " + this.getExpr().toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprTargetedBlock.class, Block.class, ExpressionType.COMBINED, "[the] target[ed] block[s] [of %players%]", "%players%'[s] target[ed] block[s]", "[the] actual[ly] target[ed] block[s] [of %players%]", "%players%'[s] actual[ly] target[ed] block[s]");
    }
}

