/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Angle Between")
@Description(value={"Gets the angle between two vectors."})
@Examples(value={"send \"%the angle between vector 1, 0, 0 and vector 0, 1, 1%\""})
@Since(value="2.2-dev28")
public class ExprVectorAngleBetween
extends SimpleExpression<Number> {
    private Expression<Vector> first;
    private Expression<Vector> second;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.first = exprs[0];
        this.second = exprs[1];
        return true;
    }

    protected Number[] get(Event e) {
        Vector v1 = this.first.getSingle(e);
        Vector v2 = this.second.getSingle(e);
        if (v1 == null || v2 == null) {
            return null;
        }
        return CollectionUtils.array(Float.valueOf(v1.angle(v2) * 57.29578f));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the angle between " + this.first.toString(e, debug) + " and " + this.second.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprVectorAngleBetween.class, Number.class, ExpressionType.SIMPLE, "[the] angle between [[the] vectors] %vector% and %vector%");
    }
}

