/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.arithmetic;

import ch.njol.skript.expressions.arithmetic.ArithmeticGettable;
import ch.njol.skript.expressions.arithmetic.NumberExpressionInfo;
import ch.njol.skript.expressions.arithmetic.Operator;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import java.util.List;
import org.bukkit.event.Event;

public class ArithmeticChain
implements ArithmeticGettable {
    private static final Checker<Object>[] CHECKERS = new Checker[]{o -> o.equals((Object)Operator.PLUS) || o.equals((Object)Operator.MINUS), o -> o.equals((Object)Operator.MULT) || o.equals((Object)Operator.DIV), o -> o.equals((Object)Operator.EXP)};
    private final ArithmeticGettable left;
    private final Operator operator;
    private final ArithmeticGettable right;

    public ArithmeticChain(ArithmeticGettable left, Operator operator, ArithmeticGettable right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    @Override
    public Number get(Event event, boolean integer) {
        return this.operator.calculate(this.left.get(event, integer), this.right.get(event, integer), integer);
    }

    public static ArithmeticGettable parse(List<Object> chain) {
        for (Checker<Object> checker : CHECKERS) {
            int lastIndex = Utils.findLastIndex(chain, checker);
            if (lastIndex == -1) continue;
            List<Object> leftChain = chain.subList(0, lastIndex);
            ArithmeticGettable left = ArithmeticChain.parse(leftChain);
            Operator operator = (Operator)((Object)chain.get(lastIndex));
            List<Object> rightChain = chain.subList(lastIndex + 1, chain.size());
            ArithmeticGettable right = ArithmeticChain.parse(rightChain);
            return new ArithmeticChain(left, operator, right);
        }
        if (chain.size() != 1) {
            throw new IllegalStateException();
        }
        return new NumberExpressionInfo((Expression)chain.get(0));
    }
}

