/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SyntaxElementInfo;
import java.util.Locale;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.eclipse.jdt.annotation.Nullable;

public final class SkriptEventInfo<E extends SkriptEvent>
extends SyntaxElementInfo<E> {
    public Class<? extends Event>[] events;
    public final String name;
    private final String id;
    private @Nullable String[] description;
    private @Nullable String[] examples;
    private @Nullable String since;
    private @Nullable String documentationID;
    private @Nullable String[] requiredPlugins;
    public static final String[] NO_DOC = new String[0];

    public SkriptEventInfo(String name, String[] patterns, Class<E> c, String originClassPath, Class<? extends Event>[] events) {
        super(patterns, c, originClassPath);
        assert (name != null);
        assert (patterns != null && patterns.length > 0);
        assert (c != null);
        assert (originClassPath != null);
        assert (events != null && events.length > 0);
        for (int i = 0; i < events.length; ++i) {
            for (int j = i + 1; j < events.length; ++j) {
                if (!events[i].isAssignableFrom(events[j]) && !events[j].isAssignableFrom(events[i]) || events[i].equals(PlayerInteractAtEntityEvent.class) || events[j].equals(PlayerInteractAtEntityEvent.class)) continue;
                throw new SkriptAPIException("The event " + name + " (" + c.getName() + ") registers with super/subclasses " + events[i].getName() + " and " + events[j].getName());
            }
        }
        this.events = events;
        this.name = name.startsWith("*") ? (name = "" + name.substring(1)) : "On " + name;
        this.id = "" + name.toLowerCase(Locale.ENGLISH).replaceAll("[#'\"<>/&]", "").replaceAll("\\s+", "_");
    }

    public SkriptEventInfo<E> description(String ... description) {
        assert (this.description == null);
        this.description = description;
        return this;
    }

    public SkriptEventInfo<E> examples(String ... examples) {
        assert (this.examples == null);
        this.examples = examples;
        return this;
    }

    public SkriptEventInfo<E> since(String since) {
        assert (this.since == null);
        this.since = since;
        return this;
    }

    public SkriptEventInfo<E> documentationID(String id) {
        assert (this.documentationID == null);
        this.documentationID = id;
        return this;
    }

    public SkriptEventInfo<E> requiredPlugins(String ... pluginNames) {
        assert (this.requiredPlugins == null);
        this.requiredPlugins = pluginNames;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable String[] getDescription() {
        return this.description;
    }

    public @Nullable String[] getExamples() {
        return this.examples;
    }

    public @Nullable String getSince() {
        return this.since;
    }

    public @Nullable String[] getRequiredPlugins() {
        return this.requiredPlugins;
    }

    public @Nullable String getDocumentationID() {
        return this.documentationID;
    }
}

