/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.Signature;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionReference<T> {
    final String functionName;
    private @Nullable Signature<? extends T> signature;
    private @Nullable Function<? extends T> function;
    private boolean singleListParam;
    private final Expression<?>[] parameters;
    private boolean single;
    final @Nullable Class<? extends T>[] returnTypes;
    private final @Nullable Node node;
    public final @Nullable String script;

    public FunctionReference(String functionName, @Nullable Node node, @Nullable String script, @Nullable Class<? extends T>[] returnTypes, Expression<?>[] params) {
        this.functionName = functionName;
        this.node = node;
        this.script = script;
        this.returnTypes = returnTypes;
        this.parameters = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateFunction(boolean first) {
        Function<? extends T> previousFunction = this.function;
        this.function = null;
        SkriptLogger.setNode(this.node);
        Skript.debug("Validating function " + this.functionName);
        Signature<?> sign = Functions.getSignature(this.functionName);
        if (sign == null) {
            if (first) {
                Skript.error("The function '" + this.functionName + "' does not exist.");
            } else {
                Skript.error("The function '" + this.functionName + "' was deleted or renamed, but is still used in other script(s). These will continue to use the old version of the function until Skript restarts.");
                this.function = previousFunction;
            }
            return false;
        }
        Class<? extends T>[] returnTypes = this.returnTypes;
        if (returnTypes != null) {
            ClassInfo rt = sign.returnType;
            if (rt == null) {
                if (first) {
                    Skript.error("The function '" + this.functionName + "' doesn't return any value.");
                } else {
                    Skript.error("The function '" + this.functionName + "' was redefined with no return value, but is still used in other script(s). These will continue to use the old version of the function until Skript restarts.");
                    this.function = previousFunction;
                }
                return false;
            }
            if (!Converters.converterExists(rt.getC(), returnTypes)) {
                if (first) {
                    Skript.error("The returned value of the function '" + this.functionName + "', " + sign.returnType + ", is " + SkriptParser.notOfType(returnTypes) + ".");
                } else {
                    Skript.error("The function '" + this.functionName + "' was redefined with a different, incompatible return type, but is still used in other script(s). These will continue to use the old version of the function until Skript restarts.");
                    this.function = previousFunction;
                }
                return false;
            }
            if (first) {
                this.single = sign.single;
            } else if (this.single && !sign.single) {
                Skript.error("The function '" + this.functionName + "' was redefined with a different, incompatible return type, but is still used in other script(s). These will continue to use the old version of the function until Skript restarts.");
                this.function = previousFunction;
                return false;
            }
        }
        boolean bl = this.singleListParam = sign.getMaxParameters() == 1 && !sign.getParameter((int)0).single;
        if (!this.singleListParam && this.parameters.length > sign.getMaxParameters()) {
            if (first) {
                if (sign.getMaxParameters() == 0) {
                    Skript.error("The function '" + this.functionName + "' has no arguments, but " + this.parameters.length + " are given. To call a function without parameters, just write the function name followed by '()', e.g. 'func()'.");
                } else {
                    Skript.error("The function '" + this.functionName + "' has only " + sign.getMaxParameters() + " argument" + (sign.getMaxParameters() == 1 ? "" : "s") + ", but " + this.parameters.length + " are given. If you want to use lists in function calls, you have to use additional parentheses, e.g. 'give(player, (iron ore and gold ore))'");
                }
            } else {
                Skript.error("The function '" + this.functionName + "' was redefined with a different, incompatible amount of arguments, but is still used in other script(s). These will continue to use the old version of the function until Skript restarts.");
                this.function = previousFunction;
            }
            return false;
        }
        if (this.parameters.length < sign.getMinParameters()) {
            if (first) {
                Skript.error("The function '" + this.functionName + "' requires at least " + sign.getMinParameters() + " argument" + (sign.getMinParameters() == 1 ? "" : "s") + ", but only " + this.parameters.length + " " + (this.parameters.length == 1 ? "is" : "are") + " given.");
            } else {
                Skript.error("The function '" + this.functionName + "' was redefined with a different, incompatible amount of arguments, but is still used in other script(s). These will continue to use the old version of the function until Skript restarts.");
                this.function = previousFunction;
            }
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            Parameter<?> p = sign.parameters[this.singleListParam ? 0 : i];
            RetainingLogHandler log = SkriptLogger.startRetainingLog();
            try {
                Expression e = this.parameters[i].getConvertedExpression(p.type.getC());
                if (e == null) {
                    if (first) {
                        if (LiteralUtils.hasUnparsedLiteral(this.parameters[i])) {
                            Skript.error("Can't understand this expression: " + this.parameters[i].toString());
                        } else {
                            Skript.error("The " + StringUtils.fancyOrderNumber(i + 1) + " argument given to the function '" + this.functionName + "' is not of the required type " + p.type + ". Check the correct order of the arguments and put lists into parentheses if appropriate (e.g. 'give(player, (iron ore and gold ore))'). Please note that storing the value in a variable and then using that variable as parameter will suppress this error, but it still won't work.");
                        }
                    } else {
                        Skript.error("The function '" + this.functionName + "' was redefined with different, incompatible arguments, but is still used in other script(s). These will continue to use the old version of the function until Skript restarts.");
                        this.function = previousFunction;
                    }
                    boolean bl2 = false;
                    return bl2;
                }
                if (p.single && !e.isSingle()) {
                    if (first) {
                        Skript.error("The " + StringUtils.fancyOrderNumber(i + 1) + " argument given to the function '" + this.functionName + "' is plural, but a single argument was expected");
                    } else {
                        Skript.error("The function '" + this.functionName + "' was redefined with different, incompatible arguments, but is still used in other script(s). These will continue to use the old version of the function until Skript restarts.");
                        this.function = previousFunction;
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                this.parameters[i] = e;
                continue;
            }
            finally {
                log.printLog();
            }
        }
        this.signature = sign;
        sign.calls.add(this);
        return true;
    }

    public @Nullable Function<? extends T> getFunction() {
        return this.function;
    }

    public boolean resetReturnValue() {
        if (this.function != null) {
            return this.function.resetReturnValue();
        }
        return false;
    }

    protected @Nullable T[] execute(Event e) {
        if (this.function == null) {
            this.function = Functions.getFunction(this.functionName);
        }
        if (this.function == null) {
            Skript.error("Couldn't resolve call for '" + this.functionName + "'. Be careful when using functions in 'script load' events!");
            return null;
        }
        Object[][] params = new Object[this.singleListParam ? 1 : this.parameters.length][];
        if (this.singleListParam && this.parameters.length > 1) {
            ArrayList l = new ArrayList();
            for (Expression<?> parameter : this.parameters) {
                l.addAll(Arrays.asList(parameter.getArray(e)));
            }
            params[0] = l.toArray();
            for (int i = 0; i < params[0].length; ++i) {
                params[0][i] = Classes.clone(params[0][i]);
            }
        } else {
            for (int i = 0; i < this.parameters.length; ++i) {
                ?[] array = this.parameters[i].getArray(e);
                params[i] = Arrays.copyOf(array, array.length);
                for (int j = 0; j < params[i].length; ++j) {
                    params[i][j] = Classes.clone(params[i][j]);
                }
            }
        }
        return this.function.execute(params);
    }

    public boolean isSingle() {
        return this.single;
    }

    public @Nullable Class<? extends T> getReturnType() {
        if (this.signature == null) {
            throw new SkriptAPIException("Signature of function is null when return type is asked!");
        }
        ClassInfo ret = this.signature.returnType;
        return ret == null ? null : ret.getC();
    }

    public String toString(@Nullable Event e, boolean debug) {
        StringBuilder b = new StringBuilder(this.functionName + "(");
        for (int i = 0; i < this.parameters.length; ++i) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(this.parameters[i].toString(e, debug));
        }
        b.append(")");
        return b.toString();
    }
}

