/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.util.Utils;
import java.util.Locale;
import org.eclipse.jdt.annotation.Nullable;

public final class Parameter<T> {
    final String name;
    final ClassInfo<T> type;
    final @Nullable Expression<? extends T> def;
    final boolean single;

    public Parameter(String name, ClassInfo<T> type, boolean single, @Nullable Expression<? extends T> def) {
        this.name = name != null ? name.toLowerCase(Locale.ENGLISH) : null;
        this.type = type;
        this.def = def;
        this.single = single;
    }

    public ClassInfo<T> getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> @Nullable Parameter<T> newInstance(String name, ClassInfo<T> type, boolean single, @Nullable String def) {
        if (!Variable.isValidVariableName(name, true, false)) {
            Skript.error("A parameter's name must be a valid variable name.");
            return null;
        }
        Expression d = null;
        if (def != null) {
            RetainingLogHandler log = SkriptLogger.startRetainingLog();
            try {
                d = new SkriptParser(def, 3, ParseContext.DEFAULT).parseExpression(type.getC());
                if (d == null || LiteralUtils.hasUnparsedLiteral(d)) {
                    log.printErrors("Can't understand this expression: " + def);
                    Parameter<T> parameter = null;
                    return parameter;
                }
                log.printLog();
            }
            finally {
                log.stop();
            }
        }
        return new Parameter<T>(name, type, single, d);
    }

    public String getName() {
        return this.name;
    }

    public @Nullable Expression<? extends T> getDefaultExpression() {
        return this.def;
    }

    public boolean isSingleValue() {
        return this.single;
    }

    public String toString() {
        return this.name + ": " + Utils.toEnglishPlural(this.type.getCodeName(), !this.single) + (this.def != null ? " = " + this.def.toString(null, true) : "");
    }
}

