/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.util;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class ConvertedExpression<F, T>
implements Expression<T> {
    protected Expression<? extends F> source;
    protected Class<T> to;
    final Converter<? super F, ? extends T> conv;
    private final Converter.ConverterInfo<? super F, ? extends T> converterInfo;
    private @Nullable ClassInfo<? super T> returnTypeInfo;

    public ConvertedExpression(Expression<? extends F> source, Class<T> to, Converter.ConverterInfo<? super F, ? extends T> info) {
        assert (source != null);
        assert (to != null);
        assert (info != null);
        this.source = source;
        this.to = to;
        this.conv = info.converter;
        this.converterInfo = info;
    }

    @SafeVarargs
    public static <F, T> @Nullable ConvertedExpression<F, T> newInstance(Expression<F> v, Class<T> ... to) {
        assert (!CollectionUtils.containsSuperclass(to, v.getReturnType()));
        for (Class<T> c : to) {
            assert (c != null);
            Converter.ConverterInfo<F, T> conv = Converters.getConverterInfo(v.getReturnType(), c);
            if (conv == null) continue;
            return new ConvertedExpression<F, T>(v, c, conv);
        }
        return null;
    }

    @Override
    public final boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult matcher) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (debug && e == null) {
            return "(" + this.source.toString(e, debug) + " >> " + this.conv + ": " + this.converterInfo.toString(e, true) + ")";
        }
        return this.source.toString(e, debug);
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public Class<T> getReturnType() {
        return this.to;
    }

    @Override
    public boolean isSingle() {
        return this.source.isSingle();
    }

    @Override
    public <R> @Nullable Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        if (CollectionUtils.containsSuperclass(to, this.to)) {
            return this;
        }
        return this.source.getConvertedExpression(to);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class<?>[] r = this.source.acceptChange(mode);
        if (r == null) {
            ClassInfo<Object> rti = this.returnTypeInfo;
            rti = Classes.getSuperClassInfo(this.getReturnType());
            this.returnTypeInfo = rti;
            Changer<Object> c = rti.getChanger();
            return c == null ? null : c.acceptChange(mode);
        }
        return r;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ClassInfo<T> rti = this.returnTypeInfo;
        if (rti != null) {
            Changer<T> c = rti.getChanger();
            if (c != null) {
                c.change(this.getArray(e), delta, mode);
            }
        } else {
            this.source.change(e, delta, mode);
        }
    }

    @Override
    public @Nullable T getSingle(Event e) {
        F f = this.source.getSingle(e);
        if (f == null) {
            return null;
        }
        return this.conv.convert(f);
    }

    @Override
    public T[] getArray(Event e) {
        return Converters.convert(this.source.getArray(e), this.to, this.conv);
    }

    @Override
    public T[] getAll(Event e) {
        return Converters.convert(this.source.getAll(e), this.to, this.conv);
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, boolean negated) {
        return negated ^ this.check(e, c);
    }

    @Override
    public boolean check(Event e, final Checker<? super T> c) {
        return this.source.check(e, new Checker<F>(){

            @Override
            public boolean check(F f) {
                Object t = ConvertedExpression.this.conv.convert(f);
                if (t == null) {
                    return false;
                }
                return c.check(t);
            }
        });
    }

    @Override
    public boolean getAnd() {
        return this.source.getAnd();
    }

    @Override
    public boolean setTime(int time) {
        return this.source.setTime(time);
    }

    @Override
    public int getTime() {
        return this.source.getTime();
    }

    @Override
    public boolean isDefault() {
        return this.source.isDefault();
    }

    @Override
    public boolean isLoopOf(String s) {
        return false;
    }

    @Override
    public @Nullable Iterator<T> iterator(Event e) {
        final Iterator<? extends F> iter = this.source.iterator(e);
        if (iter == null) {
            return null;
        }
        return new Iterator<T>(){
            @Nullable T next = null;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (this.next == null && iter.hasNext()) {
                    Object f = iter.next();
                    this.next = f == null ? null : ConvertedExpression.this.conv.convert(f);
                }
                return this.next != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object n = this.next;
                this.next = null;
                assert (n != null);
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Expression<?> getSource() {
        return this.source;
    }

    @Override
    public Expression<? extends T> simplify() {
        Expression c = this.source.simplify().getConvertedExpression(this.to);
        if (c != null) {
            return c;
        }
        return this;
    }

    @Override
    public @Nullable Object[] beforeChange(Expression<?> changed, @Nullable Object[] delta) {
        return this.source.beforeChange(changed, delta);
    }
}

