/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.ContainerExpression;
import ch.njol.skript.util.Container;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class SecLoop
extends Section {
    private Expression<?> expr;
    private final transient Map<Event, Object> current = new WeakHashMap<Event, Object>();
    private final transient Map<Event, Iterator<?>> currentIter = new WeakHashMap();
    private @Nullable TriggerItem actualNext;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        this.expr = LiteralUtils.defendExpression(exprs[0]);
        if (!LiteralUtils.canInitSafely(this.expr)) {
            Skript.error("Can't understand this loop: '" + parseResult.expr.substring(5) + "'");
            return false;
        }
        if (Container.class.isAssignableFrom(this.expr.getReturnType())) {
            Container.ContainerType type = this.expr.getReturnType().getAnnotation(Container.ContainerType.class);
            if (type == null) {
                throw new SkriptAPIException(this.expr.getReturnType().getName() + " implements Container but is missing the required @ContainerType annotation");
            }
            this.expr = new ContainerExpression(this.expr, type.value());
        }
        if (this.expr.isSingle()) {
            Skript.error("Can't loop " + this.expr + " because it's only a single value");
            return false;
        }
        this.loadOptionalCode(sectionNode);
        super.setNext(this);
        return true;
    }

    @Override
    protected @Nullable TriggerItem walk(Event e) {
        Iterator<?> iter = this.currentIter.get(e);
        if (iter == null) {
            Iterator<Object> iterator = iter = this.expr instanceof Variable ? ((Variable)this.expr).variablesIterator(e) : this.expr.iterator(e);
            if (iter != null) {
                if (iter.hasNext()) {
                    this.currentIter.put(e, iter);
                } else {
                    iter = null;
                }
            }
        }
        if (iter == null || !iter.hasNext()) {
            this.exit(e);
            this.debug(e, false);
            return this.actualNext;
        }
        this.current.put(e, iter.next());
        return this.walk(e, true);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "loop " + this.expr.toString(e, debug);
    }

    public @Nullable Object getCurrent(Event e) {
        return this.current.get(e);
    }

    public Expression<?> getLoopedExpression() {
        return this.expr;
    }

    @Override
    public SecLoop setNext(@Nullable TriggerItem next) {
        this.actualNext = next;
        return this;
    }

    public @Nullable TriggerItem getActualNext() {
        return this.actualNext;
    }

    public void exit(Event event) {
        this.current.remove(event);
        this.currentIter.remove(event);
    }

    static {
        Skript.registerSection(SecLoop.class, "loop %objects%");
    }
}

