/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util.slot;

import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.slot.Slot;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class CursorSlot
extends Slot {
    private final Player player;

    public CursorSlot(Player p) {
        this.player = p;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public @Nullable ItemStack getItem() {
        return this.player.getItemOnCursor();
    }

    @Override
    public void setItem(@Nullable ItemStack item) {
        this.player.setItemOnCursor(item);
        PlayerUtils.updateInventory(this.player);
    }

    @Override
    public int getAmount() {
        return this.player.getItemOnCursor().getAmount();
    }

    @Override
    public void setAmount(int amount) {
        this.player.getItemOnCursor().setAmount(amount);
    }

    @Override
    public boolean isSameSlot(Slot o) {
        if (!(o instanceof CursorSlot)) {
            return false;
        }
        return ((CursorSlot)o).getPlayer().equals(this.player);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "cursor slot of " + Classes.toString(this.player);
    }
}

