/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.tests.runner.TestMode;
import ch.njol.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class SkriptCommandTabCompleter
implements TabCompleter {
    @Nullable
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> options = new ArrayList<String>();
        if (!command.getName().equalsIgnoreCase("skript")) {
            return null;
        }
        if (args[0].equalsIgnoreCase("update") && args.length == 2) {
            options.add("check");
            options.add("changes");
            options.add("download");
        } else if (args[0].matches("(?i)(reload|disable|enable)") && args.length == 2) {
            File scripts = new File(Skript.getInstance().getDataFolder(), "scripts");
            String scriptArg = StringUtils.join(args, " ", 1, args.length);
            String fs = File.separator;
            try {
                Files.walk(scripts.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(f -> !f.isDirectory() && StringUtils.endsWithIgnoreCase(f.getName(), ".sk") || f.isDirectory()).filter(f -> {
                    if (args[0].equalsIgnoreCase("enable")) {
                        return f.getName().startsWith("-");
                    }
                    return !f.getAbsolutePath().matches(".*?(\\\\-|/-|^-).*") && (f.isDirectory() && !f.getAbsolutePath().matches(".*?(\\\\\\.|/\\.|^\\.).*") || !f.isDirectory());
                }).filter(f -> scriptArg.length() > 0 ? f.getName().startsWith(scriptArg) : true).forEach(f -> {
                    if (!f.toString().equals(scripts.toString())) {
                        options.add(f.toString().replace(scripts.toPath() + (!f.isDirectory() && f.getParentFile().toPath().toString().equals(scripts.toPath().toString()) ? fs : ""), "") + (f.isDirectory() && f.toString().length() > 0 ? fs : ""));
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            options.add("all");
            if (args[0].equalsIgnoreCase("reload")) {
                options.add("config");
                options.add("aliases");
                options.add("scripts");
            }
        } else if (args.length == 1) {
            options.add("help");
            options.add("reload");
            options.add("enable");
            options.add("disable");
            options.add("update");
            options.add("info");
            if (new File(Skript.getInstance().getDataFolder() + "/doc-templates").exists()) {
                options.add("gen-docs");
            }
            if (TestMode.DEV_MODE) {
                options.add("test");
            }
        }
        return options;
    }
}

