/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.util.Experience;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffectType;
import org.eclipse.jdt.annotation.Nullable;

public class DefaultChangers {
    public static final Changer<Entity> entityChanger = new Changer<Entity>(){

        @Override
        public @Nullable Class<? extends Object>[] acceptChange(Changer.ChangeMode mode) {
            switch (mode) {
                case ADD: {
                    return CollectionUtils.array(ItemType[].class, Inventory.class, Experience[].class);
                }
                case DELETE: {
                    return CollectionUtils.array(new Class[0]);
                }
                case REMOVE: {
                    return CollectionUtils.array(PotionEffectType[].class, ItemType[].class, Inventory.class);
                }
                case REMOVE_ALL: {
                    return CollectionUtils.array(PotionEffectType[].class, ItemType[].class);
                }
                case SET: 
                case RESET: {
                    return null;
                }
            }
            assert (false);
            return null;
        }

        public void change(Entity[] entities, @Nullable Object[] delta, Changer.ChangeMode mode) {
            if (delta == null) {
                for (Entity e : entities) {
                    if (e instanceof Player) continue;
                    e.remove();
                }
                return;
            }
            for (Entity e : entities) {
                for (Object d : delta) {
                    PlayerInventory invi;
                    if (d instanceof PotionEffectType) {
                        assert (mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.REMOVE_ALL);
                        if (!(e instanceof LivingEntity)) continue;
                        ((LivingEntity)e).removePotionEffect((PotionEffectType)d);
                        continue;
                    }
                    if (!(e instanceof Player)) continue;
                    Player p = (Player)e;
                    if (d instanceof Experience) {
                        p.giveExp(((Experience)d).getXP());
                        continue;
                    }
                    if (d instanceof Inventory) {
                        invi = p.getInventory();
                        if (mode == Changer.ChangeMode.ADD) {
                            for (ItemStack i : (Inventory)d) {
                                if (i == null) continue;
                                invi.addItem(new ItemStack[]{i});
                            }
                            continue;
                        }
                        invi.removeItem(((Inventory)d).getContents());
                        continue;
                    }
                    if (!(d instanceof ItemType)) continue;
                    invi = p.getInventory();
                    if (mode == Changer.ChangeMode.ADD) {
                        ((ItemType)d).addTo((Inventory)invi);
                        continue;
                    }
                    if (mode == Changer.ChangeMode.REMOVE) {
                        ((ItemType)d).removeFrom((Inventory)invi);
                        continue;
                    }
                    ((ItemType)d).removeAll((Inventory)invi);
                }
                if (!(e instanceof Player)) continue;
                PlayerUtils.updateInventory((Player)e);
            }
        }
    };
    public static final Changer<Player> playerChanger = new Changer<Player>(){

        @Override
        public @Nullable Class<? extends Object>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.DELETE) {
                return null;
            }
            return entityChanger.acceptChange(mode);
        }

        public void change(Player[] players, @Nullable Object[] delta, Changer.ChangeMode mode) {
            entityChanger.change((Entity[])players, delta, mode);
        }
    };
    public static final Changer<Entity> nonLivingEntityChanger = new Changer<Entity>(){

        @Override
        public @Nullable Class<Object>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.DELETE) {
                return CollectionUtils.array(new Class[0]);
            }
            return null;
        }

        public void change(Entity[] entities, @Nullable Object[] delta, Changer.ChangeMode mode) {
            assert (mode == Changer.ChangeMode.DELETE);
            for (Entity e : entities) {
                if (e instanceof Player) continue;
                e.remove();
            }
        }
    };
    public static final Changer<Item> itemChanger = new Changer<Item>(){

        @Override
        public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.SET) {
                return CollectionUtils.array(ItemStack.class);
            }
            return nonLivingEntityChanger.acceptChange(mode);
        }

        public void change(Item[] what, @Nullable Object[] delta, Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.SET) {
                assert (delta != null);
                for (Item i : what) {
                    i.setItemStack((ItemStack)delta[0]);
                }
            } else {
                nonLivingEntityChanger.change((Entity[])what, delta, mode);
            }
        }
    };
    public static final Changer<Inventory> inventoryChanger = new Changer<Inventory>(){
        private Material[] cachedMaterials = Material.values();

        @Override
        public @Nullable Class<? extends Object>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.RESET) {
                return null;
            }
            if (mode == Changer.ChangeMode.REMOVE_ALL) {
                return CollectionUtils.array(ItemType[].class);
            }
            if (mode == Changer.ChangeMode.SET) {
                return CollectionUtils.array(ItemType[].class, Inventory.class);
            }
            return CollectionUtils.array(ItemType[].class, Inventory[].class);
        }

        public void change(Inventory[] invis, @Nullable Object[] delta, Changer.ChangeMode mode) {
            for (Inventory invi : invis) {
                assert (invi != null);
                switch (mode) {
                    case DELETE: {
                        invi.clear();
                        break;
                    }
                    case SET: {
                        invi.clear();
                    }
                    case ADD: {
                        int n;
                        Object[] items;
                        assert (delta != null);
                        if (delta instanceof ItemStack[]) {
                            items = (ItemStack[])delta;
                            if (items.length > 36) {
                                return;
                            }
                            Object[] objectArray = delta;
                            n = objectArray.length;
                            for (int i = 0; i < n; ++i) {
                                Object d = objectArray[i];
                                if (d instanceof Inventory) {
                                    for (ItemStack i2 : (Inventory)d) {
                                        if (i2 == null) continue;
                                        invi.addItem(new ItemStack[]{i2});
                                    }
                                    continue;
                                }
                                ((ItemType)d).addTo(invi);
                            }
                            break;
                        }
                        items = delta;
                        int n2 = items.length;
                        for (n = 0; n < n2; ++n) {
                            Object d = items[n];
                            if (d instanceof ItemStack) {
                                new ItemType((ItemStack)d).addTo(invi);
                                continue;
                            }
                            if (d instanceof ItemType) {
                                ((ItemType)d).addTo(invi);
                                continue;
                            }
                            if (d instanceof Block) {
                                new ItemType((Block)d).addTo(invi);
                                continue;
                            }
                            Skript.error("Can't " + d.toString() + " to an inventory!");
                        }
                        break;
                    }
                    case REMOVE: 
                    case REMOVE_ALL: {
                        int n;
                        assert (delta != null);
                        if (delta.length == this.cachedMaterials.length) {
                            boolean equal = true;
                            for (int i = 0; i < delta.length; ++i) {
                                if (!(delta[i] instanceof ItemType)) {
                                    equal = false;
                                    break;
                                }
                                if (((ItemType)delta[i]).getMaterial() == this.cachedMaterials[i]) continue;
                                equal = false;
                                break;
                            }
                            if (equal) {
                                invi.clear();
                                break;
                            }
                        }
                        Object[] equal = delta;
                        int n3 = equal.length;
                        for (n = 0; n < n3; ++n) {
                            Object d = equal[n];
                            if (d instanceof Inventory) {
                                assert (mode == Changer.ChangeMode.REMOVE);
                                invi.removeItem(((Inventory)d).getContents());
                                continue;
                            }
                            if (mode == Changer.ChangeMode.REMOVE) {
                                ((ItemType)d).removeFrom(invi);
                                continue;
                            }
                            ((ItemType)d).removeAll(invi);
                        }
                        break;
                    }
                    case RESET: {
                        assert (false);
                        break;
                    }
                }
                InventoryHolder holder = invi.getHolder();
                if (!(holder instanceof Player)) continue;
                ((Player)holder).updateInventory();
            }
        }
    };
    public static final Changer<Block> blockChanger = new Changer<Block>(){

        @Override
        public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.RESET) {
                return null;
            }
            if (mode == Changer.ChangeMode.SET) {
                if (Skript.classExists("org.bukkit.block.data.BlockData")) {
                    return CollectionUtils.array(ItemType.class, BlockData.class);
                }
                return CollectionUtils.array(ItemType.class);
            }
            return CollectionUtils.array(ItemType[].class, Inventory[].class);
        }

        public void change(Block[] blocks, @Nullable Object[] delta, Changer.ChangeMode mode) {
            block6: for (Block block : blocks) {
                assert (block != null);
                switch (mode) {
                    case SET: {
                        assert (delta != null);
                        Object o = delta[0];
                        if (o instanceof ItemType) {
                            ((ItemType)delta[0]).getBlock().setBlock(block, true);
                            continue block6;
                        }
                        if (!(o instanceof BlockData)) continue block6;
                        block.setBlockData((BlockData)o);
                        continue block6;
                    }
                    case DELETE: {
                        block.setType(Material.AIR, true);
                        continue block6;
                    }
                    case ADD: 
                    case REMOVE: 
                    case REMOVE_ALL: {
                        assert (delta != null);
                        BlockState state = block.getState();
                        if (!(state instanceof InventoryHolder)) continue block6;
                        Inventory invi = ((InventoryHolder)state).getInventory();
                        if (mode == Changer.ChangeMode.ADD) {
                            for (Object d : delta) {
                                if (d instanceof Inventory) {
                                    for (ItemStack i : (Inventory)d) {
                                        if (i == null) continue;
                                        invi.addItem(new ItemStack[]{i});
                                    }
                                    continue;
                                }
                                ((ItemType)d).addTo(invi);
                            }
                        } else {
                            for (Object d : delta) {
                                if (d instanceof Inventory) {
                                    invi.removeItem(((Inventory)d).getContents());
                                    continue;
                                }
                                if (mode == Changer.ChangeMode.REMOVE) {
                                    ((ItemType)d).removeFrom(invi);
                                    continue;
                                }
                                ((ItemType)d).removeAll(invi);
                            }
                        }
                        state.update();
                        continue block6;
                    }
                    case RESET: {
                        assert (false);
                        continue block6;
                    }
                }
            }
        }
    };
}

