/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.entity.EntityType;
import ch.njol.skript.entity.XpOrbData;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.BlockInventoryHolder;
import ch.njol.skript.util.BlockUtils;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.Experience;
import ch.njol.skript.util.slot.Slot;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

public class DefaultConverters {
    static {
        Converters.registerConverter(Integer.class, Long.class, Integer::longValue);
        Converters.registerConverter(OfflinePlayer.class, PlayerInventory.class, new Converter<OfflinePlayer, PlayerInventory>(){

            @Override
            public @Nullable PlayerInventory convert(OfflinePlayer p) {
                if (!p.isOnline()) {
                    return null;
                }
                Player online = p.getPlayer();
                assert (online != null);
                return online.getInventory();
            }
        }, 4);
        Converters.registerConverter(OfflinePlayer.class, Player.class, new Converter<OfflinePlayer, Player>(){

            @Override
            public @Nullable Player convert(OfflinePlayer p) {
                return p.getPlayer();
            }
        }, 4);
        Converters.registerConverter(CommandSender.class, Player.class, new Converter<CommandSender, Player>(){

            @Override
            public @Nullable Player convert(CommandSender s) {
                if (s instanceof Player) {
                    return (Player)s;
                }
                return null;
            }
        });
        Converters.registerConverter(BlockCommandSender.class, Block.class, new Converter<BlockCommandSender, Block>(){

            @Override
            public @Nullable Block convert(BlockCommandSender s) {
                return s.getBlock();
            }
        });
        Converters.registerConverter(Entity.class, Player.class, new Converter<Entity, Player>(){

            @Override
            public @Nullable Player convert(Entity e) {
                if (e instanceof Player) {
                    return (Player)e;
                }
                return null;
            }
        });
        Converters.registerConverter(Entity.class, LivingEntity.class, new Converter<Entity, LivingEntity>(){

            @Override
            public @Nullable LivingEntity convert(Entity e) {
                if (e instanceof LivingEntity) {
                    return (LivingEntity)e;
                }
                return null;
            }
        });
        Converters.registerConverter(Block.class, Inventory.class, new Converter<Block, Inventory>(){

            @Override
            public @Nullable Inventory convert(Block b) {
                if (b.getState() instanceof InventoryHolder) {
                    return ((InventoryHolder)b.getState()).getInventory();
                }
                return null;
            }
        }, 4);
        Converters.registerConverter(Entity.class, Inventory.class, new Converter<Entity, Inventory>(){

            @Override
            public @Nullable Inventory convert(Entity e) {
                if (e instanceof InventoryHolder) {
                    return ((InventoryHolder)e).getInventory();
                }
                return null;
            }
        }, 4);
        Converters.registerConverter(Block.class, ItemType.class, new Converter<Block, ItemType>(){

            @Override
            public ItemType convert(Block b) {
                return new ItemType(b);
            }
        }, 5);
        Converters.registerConverter(Block.class, Location.class, new Converter<Block, Location>(){

            @Override
            public @Nullable Location convert(Block b) {
                return BlockUtils.getLocation(b);
            }
        }, 4);
        Converters.registerConverter(Entity.class, Location.class, new Converter<Entity, Location>(){

            @Override
            public @Nullable Location convert(Entity e) {
                return e.getLocation();
            }
        }, 4);
        Converters.registerConverter(Entity.class, EntityData.class, new Converter<Entity, EntityData>(){

            @Override
            public EntityData convert(Entity e) {
                return EntityData.fromEntity(e);
            }
        }, 6);
        Converters.registerConverter(EntityData.class, EntityType.class, new Converter<EntityData, EntityType>(){

            @Override
            public EntityType convert(EntityData data) {
                return new EntityType(data, -1);
            }
        });
        Converters.registerConverter(ItemType.class, ItemStack.class, new Converter<ItemType, ItemStack>(){

            @Override
            public @Nullable ItemStack convert(ItemType i) {
                return i.getRandom();
            }
        });
        Converters.registerConverter(ItemStack.class, ItemType.class, new Converter<ItemStack, ItemType>(){

            @Override
            public ItemType convert(ItemStack i) {
                return new ItemType(i);
            }
        });
        Converters.registerConverter(Experience.class, XpOrbData.class, new Converter<Experience, XpOrbData>(){

            @Override
            public XpOrbData convert(Experience e) {
                return new XpOrbData(e.getXP());
            }
        });
        Converters.registerConverter(XpOrbData.class, Experience.class, new Converter<XpOrbData, Experience>(){

            @Override
            public Experience convert(XpOrbData e) {
                return new Experience(e.getExperience());
            }
        });
        Converters.registerConverter(Slot.class, ItemType.class, new Converter<Slot, ItemType>(){

            @Override
            public ItemType convert(Slot s) {
                ItemStack i = s.getItem();
                return new ItemType(i != null ? i : new ItemStack(Material.AIR, 1));
            }
        });
        Converters.registerConverter(Block.class, InventoryHolder.class, new Converter<Block, InventoryHolder>(){

            @Override
            public @Nullable InventoryHolder convert(Block b) {
                BlockState s = b.getState();
                if (s instanceof InventoryHolder) {
                    return (InventoryHolder)s;
                }
                return null;
            }
        }, 6);
        Converters.registerConverter(InventoryHolder.class, Block.class, new Converter<InventoryHolder, Block>(){

            @Override
            public @Nullable Block convert(InventoryHolder holder) {
                if (holder instanceof BlockState) {
                    return new BlockInventoryHolder((BlockState)holder);
                }
                if (holder instanceof DoubleChest) {
                    return holder.getInventory().getLocation().getBlock();
                }
                return null;
            }
        });
        Converters.registerConverter(InventoryHolder.class, Entity.class, new Converter<InventoryHolder, Entity>(){

            @Override
            public @Nullable Entity convert(InventoryHolder holder) {
                if (holder instanceof Entity) {
                    return (Entity)holder;
                }
                return null;
            }
        });
        Converters.registerConverter(Enchantment.class, EnchantmentType.class, new Converter<Enchantment, EnchantmentType>(){

            @Override
            public EnchantmentType convert(Enchantment e) {
                return new EnchantmentType(e, -1);
            }
        });
        Converters.registerConverter(Vector.class, Direction.class, new Converter<Vector, Direction>(){

            @Override
            public @Nullable Direction convert(Vector vector) {
                return new Direction(vector);
            }
        });
        if (Skript.isRunningMinecraft(1, 11)) {
            Converters.registerConverter(EnchantmentOffer.class, EnchantmentType.class, new Converter<EnchantmentOffer, EnchantmentType>(){

                @Override
                public @Nullable EnchantmentType convert(EnchantmentOffer eo) {
                    return new EnchantmentType(eo.getEnchantment(), eo.getEnchantmentLevel());
                }
            });
        }
        Converters.registerConverter(String.class, World.class, Bukkit::getWorld);
    }
}

