/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Enchanted")
@Description(value={"Checks whether an item is enchanted."})
@Examples(value={"tool of the player is enchanted with efficiency 2", "helm, chestplate, leggings or boots are enchanted"})
@Since(value="1.4.6")
public class CondIsEnchanted
extends Condition {
    private Expression<ItemType> items;
    private @Nullable Expression<EnchantmentType> enchs;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.items = exprs[0];
        this.enchs = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        if (this.enchs != null) {
            return this.items.check(e, item -> this.enchs.check(e, xva$0 -> item.hasEnchantments((EnchantmentType)xva$0)), this.isNegated());
        }
        return this.items.check(e, ItemType::hasEnchantments, this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        Expression<EnchantmentType> es = this.enchs;
        return PropertyCondition.toString(this, PropertyCondition.PropertyType.BE, e, debug, this.items, "enchanted" + (es == null ? "" : " with " + es.toString(e, debug)));
    }

    static {
        PropertyCondition.register(CondIsEnchanted.class, "enchanted [with %-enchantmenttype%]", "itemtypes");
    }
}

