/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.doc;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Documentation;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.NoDoc;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.registrations.Classes;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.Nullable;

public class HTMLGenerator {
    private File template;
    private File output;
    private String skeleton;
    private static final AnnotatedComparator annotatedComparator = new AnnotatedComparator();
    private static final EventComparator eventComparator = new EventComparator();
    private static final ClassInfoComparator classInfoComparator = new ClassInfoComparator();
    private static final FunctionComparator functionComparator = new FunctionComparator();

    public HTMLGenerator(File templateDir, File outputDir) {
        this.template = templateDir;
        this.output = outputDir;
        this.skeleton = HTMLGenerator.readFile(new File(this.template + "/template.html"));
    }

    private static <T> Iterator<T> sortedIterator(Iterator<T> it, Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Collections.sort(list, comparator);
        return list.iterator();
    }

    public void generate() {
        for (File f : this.template.listFiles()) {
            String name;
            if (f.getName().matches("css|js|assets")) {
                String slashName = "/" + f.getName();
                File fileTo = new File(this.output + slashName);
                fileTo.mkdirs();
                for (File filesInside : new File(this.template + slashName).listFiles()) {
                    if (filesInside.isDirectory()) continue;
                    if (!filesInside.getName().toLowerCase(Locale.ENGLISH).endsWith(".png")) {
                        HTMLGenerator.writeFile(new File(fileTo + "/" + filesInside.getName()), HTMLGenerator.readFile(filesInside));
                        continue;
                    }
                    if (filesInside.getName().matches("(?i)(.*)\\.(html?|js|css|json)")) continue;
                    try {
                        Files.copy((File)filesInside, (File)new File(fileTo + "/" + filesInside.getName()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                continue;
            }
            if (f.isDirectory() || f.getName().endsWith("template.html") || f.getName().endsWith(".md")) continue;
            Skript.info("Creating documentation for " + f.getName());
            String content = HTMLGenerator.readFile(f);
            String page = f.getName().endsWith(".html") ? this.skeleton.replace("${content}", content) : content;
            page = page.replace("${skript.version}", Skript.getVersion().toString());
            page = page.replace("${skript.build.date}", new SimpleDateFormat("dd/MM/yyyy").format(new Date()));
            page = page.replace("${pagename}", f.getName().replace(".html", ""));
            ArrayList replace = Lists.newArrayList();
            int include = page.indexOf("${include");
            while (include != -1) {
                int endIncl = page.indexOf("}", include);
                name = page.substring(include + 10, endIncl);
                replace.add(name);
                include = page.indexOf("${include", endIncl);
            }
            for (String name2 : replace) {
                String temp = HTMLGenerator.readFile(new File(this.template + "/templates/" + name2));
                temp = temp.replace("${skript.version}", Skript.getVersion().toString());
                page = page.replace("${include " + name2 + "}", temp);
            }
            int generate = page.indexOf("${generate");
            while (generate != -1) {
                int nextBracket = page.indexOf("}", generate);
                String[] genParams = page.substring(generate + 11, nextBracket).split(" ");
                StringBuilder generated = new StringBuilder();
                String descTemp = HTMLGenerator.readFile(new File(this.template + "/templates/" + genParams[1]));
                String genType = genParams[0];
                if (genType.equals("expressions")) {
                    Iterator<ExpressionInfo<?, ?>> it = HTMLGenerator.sortedIterator(Skript.getExpressions(), annotatedComparator);
                    while (it.hasNext()) {
                        ExpressionInfo<?, ?> info = it.next();
                        assert (info != null);
                        if (info.c.getAnnotation(NoDoc.class) != null) continue;
                        String string = this.generateAnnotated(descTemp, info, generated.toString());
                        generated.append(string);
                    }
                } else if (genType.equals("effects")) {
                    ArrayList<SyntaxElementInfo<? extends Effect>> effects = new ArrayList<SyntaxElementInfo<? extends Effect>>(Skript.getEffects());
                    Collections.sort(effects, annotatedComparator);
                    for (SyntaxElementInfo syntaxElementInfo : effects) {
                        assert (syntaxElementInfo != null);
                        if (syntaxElementInfo.c.getAnnotation(NoDoc.class) != null) continue;
                        generated.append(this.generateAnnotated(descTemp, syntaxElementInfo, generated.toString()));
                    }
                } else if (genType.equals("conditions")) {
                    ArrayList<SyntaxElementInfo<? extends Condition>> conditions = new ArrayList<SyntaxElementInfo<? extends Condition>>(Skript.getConditions());
                    Collections.sort(conditions, annotatedComparator);
                    for (SyntaxElementInfo syntaxElementInfo : conditions) {
                        assert (syntaxElementInfo != null);
                        if (syntaxElementInfo.c.getAnnotation(NoDoc.class) != null) continue;
                        generated.append(this.generateAnnotated(descTemp, syntaxElementInfo, generated.toString()));
                    }
                } else if (genType.equals("events")) {
                    ArrayList events = new ArrayList(Skript.getEvents());
                    Collections.sort(events, eventComparator);
                    for (SkriptEventInfo skriptEventInfo : events) {
                        assert (skriptEventInfo != null);
                        if (skriptEventInfo.c.getAnnotation(NoDoc.class) != null) continue;
                        generated.append(this.generateEvent(descTemp, skriptEventInfo, generated.toString()));
                    }
                } else if (genType.equals("classes")) {
                    ArrayList classes = new ArrayList(Classes.getClassInfos());
                    Collections.sort(classes, classInfoComparator);
                    for (ClassInfo classInfo : classes) {
                        if (ClassInfo.NO_DOC.equals(classInfo.getDocName())) continue;
                        assert (classInfo != null);
                        generated.append(this.generateClass(descTemp, classInfo, generated.toString()));
                    }
                } else if (genType.equals("functions")) {
                    ArrayList functions = new ArrayList(Functions.getJavaFunctions());
                    Collections.sort(functions, functionComparator);
                    for (JavaFunction javaFunction : functions) {
                        assert (javaFunction != null);
                        generated.append(this.generateFunction(descTemp, javaFunction));
                    }
                }
                page = page.replace(page.substring(generate, nextBracket + 1), generated.toString());
                generate = page.indexOf("${generate", nextBracket);
            }
            name = f.getName();
            if (name.endsWith(".html")) {
                page = page.replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
                assert (page != null);
                page = HTMLGenerator.minifyHtml(page);
            }
            assert (page != null);
            HTMLGenerator.writeFile(new File(this.output + File.separator + name), page);
        }
    }

    private static String minifyHtml(String page) {
        int c;
        StringBuilder sb = new StringBuilder(page.length());
        boolean space = false;
        for (int i = 0; i < page.length(); i += Character.charCount(c)) {
            c = page.codePointAt(i);
            if (c == 10 || c == 32) {
                if (space) continue;
                sb.append(' ');
                space = true;
                continue;
            }
            space = false;
            sb.appendCodePoint(c);
        }
        return HTMLGenerator.replaceBR(sb.toString());
    }

    private static String replaceBR(String page) {
        return page.replaceAll("<br/>", "\n");
    }

    private static String handleIf(String desc, String start, boolean value) {
        int ifStart = desc.indexOf(start);
        while (ifStart != -1) {
            int ifEnd = desc.indexOf("${end}", ifStart);
            String data = desc.substring(ifStart + start.length() + 1, ifEnd);
            String before = desc.substring(0, ifStart);
            String after = desc.substring(ifEnd + 6);
            desc = value ? before + data + after : before + after;
            ifStart = desc.indexOf(start, ifEnd);
        }
        return desc;
    }

    private String generateAnnotated(String descTemp, SyntaxElementInfo<?> info, @Nullable String page) {
        String ID;
        Class c = info.c;
        String desc = "";
        Name name = c.getAnnotation(Name.class);
        desc = descTemp.replace("${element.name}", this.getNullOrEmptyDefault(name.value(), "Unknown Name"));
        Since since = c.getAnnotation(Since.class);
        desc = desc.replace("${element.since}", this.getNullOrEmptyDefault(since.value(), "Unknown"));
        Description description = c.getAnnotation(Description.class);
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join((Object[])this.getNullOrEmptyDefault(description.value(), "Unknown description.")).replace("\n\n", "<p>"));
        desc = desc.replace("${element.desc-safe}", Joiner.on((String)"\n").join((Object[])this.getNullOrEmptyDefault(description.value(), "Unknown description.")).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        Examples examples = c.getAnnotation(Examples.class);
        desc = desc.replace("${element.examples}", Joiner.on((String)"<br>").join((Object[])this.getNullOrEmptyDefault(examples.value(), "Missing examples.")));
        desc = desc.replace("${element.examples-safe}", Joiner.on((String)"\\n").join((Object[])this.getNullOrEmptyDefault(examples.value(), "Missing examples.")).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        DocumentationId DocID = c.getAnnotation(DocumentationId.class);
        String string = ID = DocID != null ? DocID.value() : info.c.getSimpleName();
        if (page != null && page.contains("#" + ID + "\"")) {
            ID = ID + "-" + (StringUtils.countMatches((String)page, (String)("#" + ID + "\"")) + 1);
        }
        desc = desc.replace("${element.id}", ID);
        Events events = c.getAnnotation(Events.class);
        assert (desc != null);
        desc = HTMLGenerator.handleIf(desc, "${if events}", events != null);
        if (events != null) {
            String[] eventNames = events.value();
            Object[] eventLinks = new String[eventNames.length];
            for (int i = 0; i < eventNames.length; ++i) {
                String eventName = eventNames[i];
                eventLinks[i] = "<a href=\"events.html#" + eventName.replace(" ", "_") + "\">" + eventName + "</a>";
            }
            desc = desc.replace("${element.events}", Joiner.on((String)", ").join(eventLinks));
        }
        desc = desc.replace("${element.events-safe}", events == null ? "" : Joiner.on((String)", ").join((Object[])events.value()));
        RequiredPlugins plugins = c.getAnnotation(RequiredPlugins.class);
        assert (desc != null);
        desc = HTMLGenerator.handleIf(desc, "${if required-plugins}", plugins != null);
        desc = desc.replace("${element.required-plugins}", plugins == null ? "" : Joiner.on((String)", ").join((Object[])plugins.value()));
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = HTMLGenerator.readFile(new File(this.template + "/templates/" + split[1]));
            StringBuilder patterns = new StringBuilder();
            for (String line : this.getNullOrEmptyDefault(info.patterns, "Missing patterns.")) {
                assert (line != null);
                line = HTMLGenerator.cleanPatterns(line);
                String parsed = pattern.replace("${element.pattern}", line);
                patterns.append(parsed);
            }
            String toReplace = "${generate element.patterns " + split[1] + "}";
            desc = desc.replace(toReplace, patterns.toString());
            desc = desc.replace("${generate element.patterns-safe " + split[1] + "}", patterns.toString().replace("\\", "\\\\"));
        }
        assert (desc != null);
        return desc;
    }

    private String generateEvent(String descTemp, SkriptEventInfo<?> info, @Nullable String page) {
        String ID;
        String desc = "";
        String docName = this.getNullOrEmptyDefault(info.getName(), "Unknown Name");
        desc = descTemp.replace("${element.name}", docName);
        String since = this.getNullOrEmptyDefault(info.getSince(), "Unknown");
        desc = desc.replace("${element.since}", since);
        Object[] description = this.getNullOrEmptyDefault(info.getDescription(), "Missing description.");
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join(description).replace("\n\n", "<p>"));
        desc = desc.replace("${element.desc-safe}", Joiner.on((String)"\\n").join(description).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        Object[] examples = this.getNullOrEmptyDefault(info.getExamples(), "Missing examples.");
        desc = desc.replace("${element.examples}", Joiner.on((String)"\n<br>").join(examples));
        desc = desc.replace("${element.examples-safe}", Joiner.on((String)"\\n").join(examples).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        String string = ID = info.getDocumentationID() != null ? info.getDocumentationID() : info.getId();
        if (page != null && page.contains("#" + ID + "\"")) {
            ID = ID + "-" + (StringUtils.countMatches((String)page, (String)("#" + ID + "\"")) + 1);
        }
        desc = desc.replace("${element.id}", ID);
        assert (desc != null);
        desc = HTMLGenerator.handleIf(desc, "${if events}", false);
        desc = HTMLGenerator.handleIf(desc, "${if required-plugins}", false);
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = HTMLGenerator.readFile(new File(this.template + "/templates/" + split[1]));
            StringBuilder patterns = new StringBuilder();
            for (String line : this.getNullOrEmptyDefault(info.patterns, "Missing patterns.")) {
                assert (line != null);
                line = HTMLGenerator.cleanPatterns(info.getName().startsWith("On ") ? "[on] " + line : line);
                String parsed = pattern.replace("${element.pattern}", line);
                patterns.append(parsed);
            }
            desc = desc.replace("${generate element.patterns " + split[1] + "}", patterns.toString());
            desc = desc.replace("${generate element.patterns-safe " + split[1] + "}", patterns.toString().replace("\\", "\\\\"));
        }
        assert (desc != null);
        return desc;
    }

    private String generateClass(String descTemp, ClassInfo<?> info, @Nullable String page) {
        String ID;
        String desc = "";
        String docName = this.getNullOrEmptyDefault(info.getDocName(), "Unknown Name");
        desc = descTemp.replace("${element.name}", docName);
        String since = this.getNullOrEmptyDefault(info.getSince(), "Unknown");
        desc = desc.replace("${element.since}", since);
        Object[] description = this.getNullOrEmptyDefault(info.getDescription(), "Missing description.");
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join(description).replace("\n\n", "<p>"));
        desc = desc.replace("${element.desc-safe}", Joiner.on((String)"\\n").join(description).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        Object[] examples = this.getNullOrEmptyDefault(info.getExamples(), "Missing examples.");
        desc = desc.replace("${element.examples}", Joiner.on((String)"\n<br>").join(examples));
        desc = desc.replace("${element.examples-safe}", Joiner.on((String)"\\n").join(examples).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        String string = ID = info.getDocumentationID() != null ? info.getDocumentationID() : info.getCodeName();
        if (page != null && page.contains("#" + ID + "\"")) {
            ID = ID + "-" + (StringUtils.countMatches((String)page, (String)("#" + ID + "\"")) + 1);
        }
        desc = desc.replace("${element.id}", ID);
        assert (desc != null);
        desc = HTMLGenerator.handleIf(desc, "${if events}", false);
        desc = HTMLGenerator.handleIf(desc, "${if required-plugins}", false);
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = HTMLGenerator.readFile(new File(this.template + "/templates/" + split[1]));
            StringBuilder patterns = new StringBuilder();
            String[] lines = this.getNullOrEmptyDefault(info.getUsage(), "Missing patterns.");
            if (lines == null) continue;
            for (String line : lines) {
                assert (line != null);
                line = HTMLGenerator.cleanPatterns(line, false);
                String parsed = pattern.replace("${element.pattern}", line);
                patterns.append(parsed);
            }
            desc = desc.replace("${generate element.patterns " + split[1] + "}", patterns.toString());
            desc = desc.replace("${generate element.patterns-safe " + split[1] + "}", patterns.toString().replace("\\", "\\\\"));
        }
        assert (desc != null);
        return desc;
    }

    private String generateFunction(String descTemp, JavaFunction<?> info) {
        String desc = "";
        String docName = this.getNullOrEmptyDefault(info.getName(), "Unknown Name");
        desc = descTemp.replace("${element.name}", docName);
        String since = this.getNullOrEmptyDefault(info.getSince(), "Unknown");
        desc = desc.replace("${element.since}", since);
        Object[] description = this.getNullOrEmptyDefault(info.getDescription(), "Missing description.");
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join(description));
        desc = desc.replace("${element.desc-safe}", Joiner.on((String)"\\n").join(description).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        Object[] examples = this.getNullOrEmptyDefault(info.getExamples(), "Missing examples.");
        desc = desc.replace("${element.examples}", Joiner.on((String)"\n<br>").join(examples));
        desc = desc.replace("${element.examples-safe}", Joiner.on((String)"\\n").join(examples).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        desc = desc.replace("${element.id}", info.getName());
        assert (desc != null);
        desc = HTMLGenerator.handleIf(desc, "${if events}", false);
        desc = HTMLGenerator.handleIf(desc, "${if required-plugins}", false);
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = HTMLGenerator.readFile(new File(this.template + "/templates/" + split[1]));
            String patterns = "";
            Parameter<?>[] params = info.getParameters();
            Object[] types = new String[params.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = params[i].toString();
            }
            String line = docName + "(" + Joiner.on((String)", ").join(types) + ")";
            patterns = patterns + pattern.replace("${element.pattern}", line);
            desc = desc.replace("${generate element.patterns " + split[1] + "}", patterns);
            desc = desc.replace("${generate element.patterns-safe " + split[1] + "}", patterns.replace("\\", "\\\\"));
        }
        assert (desc != null);
        return desc;
    }

    private static String readFile(File f) {
        try {
            return Files.toString((File)f, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static void writeFile(File f, String data) {
        try {
            Files.write((CharSequence)data, (File)f, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String cleanPatterns(String patterns) {
        return Documentation.cleanPatterns(patterns);
    }

    private static String cleanPatterns(String patterns, boolean escapeHTML) {
        if (escapeHTML) {
            return Documentation.cleanPatterns(patterns);
        }
        return Documentation.cleanPatterns(patterns, false);
    }

    public String getNullOrEmptyDefault(@Nullable String string, String message) {
        return string == null || string.isEmpty() ? message : string;
    }

    public String[] getNullOrEmptyDefault(@Nullable String[] string, String message) {
        String[] stringArray;
        if (string == null || string.length == 0 || string[0].equals("")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = message;
        } else {
            stringArray = string;
        }
        return stringArray;
    }

    private static class AnnotatedComparator
    implements Comparator<SyntaxElementInfo<?>> {
        @Override
        public int compare(@Nullable SyntaxElementInfo<?> o1, @Nullable SyntaxElementInfo<?> o2) {
            if (o1 == null || o2 == null) {
                assert (false);
                throw new NullPointerException();
            }
            if (o1.c.getAnnotation(NoDoc.class) != null) {
                if (o2.c.getAnnotation(NoDoc.class) != null) {
                    return 0;
                }
                return 1;
            }
            if (o2.c.getAnnotation(NoDoc.class) != null) {
                return -1;
            }
            Name name1 = o1.c.getAnnotation(Name.class);
            Name name2 = o2.c.getAnnotation(Name.class);
            if (name1 == null) {
                throw new SkriptAPIException("Name annotation expected: " + o1.c);
            }
            if (name2 == null) {
                throw new SkriptAPIException("Name annotation expected: " + o2.c);
            }
            return name1.value().compareTo(name2.value());
        }
    }

    private static class EventComparator
    implements Comparator<SkriptEventInfo<?>> {
        @Override
        public int compare(@Nullable SkriptEventInfo<?> o1, @Nullable SkriptEventInfo<?> o2) {
            if (o1 == null || o2 == null) {
                assert (false);
                throw new NullPointerException();
            }
            if (o1.c.getAnnotation(NoDoc.class) != null) {
                return 1;
            }
            if (o2.c.getAnnotation(NoDoc.class) != null) {
                return -1;
            }
            return o1.name.compareTo(o2.name);
        }
    }

    private static class ClassInfoComparator
    implements Comparator<ClassInfo<?>> {
        @Override
        public int compare(@Nullable ClassInfo<?> o1, @Nullable ClassInfo<?> o2) {
            String name2;
            if (o1 == null || o2 == null) {
                assert (false);
                throw new NullPointerException();
            }
            String name1 = o1.getDocName();
            if (name1 == null) {
                name1 = o1.getCodeName();
            }
            if ((name2 = o2.getDocName()) == null) {
                name2 = o2.getCodeName();
            }
            return name1.compareTo(name2);
        }
    }

    private static class FunctionComparator
    implements Comparator<JavaFunction<?>> {
        @Override
        public int compare(@Nullable JavaFunction<?> o1, @Nullable JavaFunction<?> o2) {
            if (o1 == null || o2 == null) {
                assert (false);
                throw new NullPointerException();
            }
            return o1.getName().compareTo(o2.getName());
        }
    }
}

