/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.EffMessage;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Broadcast")
@Description(value={"Broadcasts a message to the server."})
@Examples(value={"broadcast \"Welcome %player% to the server!\"", "broadcast \"Woah! It's a message!\""})
@Since(value="1.0, 2.6 (broadcasting objects), 2.6.1 (using advanced formatting)")
public class EffBroadcast
extends Effect {
    private Expression<?> messageExpr;
    private Expression<?>[] messages;
    private @Nullable Expression<World> worlds;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Expression[] expressionArray;
        this.messageExpr = LiteralUtils.defendExpression(exprs[0]);
        if (this.messageExpr instanceof ExpressionList) {
            expressionArray = ((ExpressionList)this.messageExpr).getExpressions();
        } else {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = this.messageExpr;
        }
        this.messages = expressionArray;
        this.worlds = exprs[1];
        return LiteralUtils.canInitSafely(this.messageExpr);
    }

    @Override
    public void execute(Event event) {
        ArrayList<ConsoleCommandSender> receivers = new ArrayList<ConsoleCommandSender>();
        if (this.worlds == null) {
            receivers.addAll(Bukkit.getOnlinePlayers());
            receivers.add(Bukkit.getConsoleSender());
        } else {
            for (World world : this.worlds.getArray(event)) {
                receivers.addAll(world.getPlayers());
            }
        }
        EffMessage.sendMessage(event, this.getMessages(), receivers.toArray(new CommandSender[0]), null);
    }

    private Expression<?>[] getMessages() {
        if (this.messageExpr instanceof ExpressionList && !this.messageExpr.getAnd()) {
            return new Expression[]{CollectionUtils.getRandom(this.messages)};
        }
        return this.messages;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "broadcast " + this.messageExpr.toString(e, debug) + (this.worlds == null ? "" : " to " + this.worlds.toString(e, debug));
    }

    static {
        Skript.registerEffect(EffBroadcast.class, "broadcast %objects% [(to|in) %-worlds%]");
    }
}

