/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Connect")
@Description(value={"Connects a player to another bungeecord server"})
@Examples(value={"connect all players to \"hub\""})
@Since(value="2.3")
public class EffConnect
extends Effect {
    public static final String BUNGEE_CHANNEL = "BungeeCord";
    public static final String GET_SERVERS_CHANNEL = "GetServers";
    public static final String CONNECT_CHANNEL = "Connect";
    private Expression<Player> players;
    private Expression<String> server;

    @Override
    protected void execute(Event e) {
        String server = this.server.getSingle(e);
        Player[] players = (Player[])this.players.stream(e).filter(OfflinePlayer::isOnline).toArray(Player[]::new);
        if (server == null || players.length == 0) {
            return;
        }
        Utils.sendPluginMessage(players[0], BUNGEE_CHANNEL, r -> GET_SERVERS_CHANNEL.equals(r.readUTF()), GET_SERVERS_CHANNEL).thenAccept(response -> {
            for (String validServer : response.readUTF().split(", ")) {
                if (!validServer.equalsIgnoreCase(server)) continue;
                for (Player player : players) {
                    Utils.sendPluginMessage(player, BUNGEE_CHANNEL, CONNECT_CHANNEL, validServer);
                }
                break;
            }
        });
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "connect " + this.players.toString(e, debug) + " to " + this.server.toString(e, debug);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.server = exprs[1];
        return true;
    }

    static {
        Skript.registerEffect(EffConnect.class, "connect %players% to [server] %string%", "send %players% to server %string%");
    }
}

