/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.util.Kleenean;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Enchant/Disenchant")
@Description(value={"Enchant or disenchant an existing item."})
@Examples(value={"enchant the player's tool with sharpness 5", "disenchant the player's tool"})
@Since(value="2.0")
public class EffEnchant
extends Effect {
    private Expression<ItemType> item;
    private @Nullable Expression<EnchantmentType> enchs;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.item = exprs[0];
        if (!Changer.ChangerUtils.acceptsChange(this.item, Changer.ChangeMode.SET, ItemStack.class)) {
            Skript.error(this.item + " cannot be changed, thus it cannot be (dis)enchanted");
            return false;
        }
        if (matchedPattern == 0) {
            this.enchs = exprs[1];
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        ItemType i = this.item.getSingle(e);
        if (i == null) {
            return;
        }
        if (this.enchs != null) {
            EnchantmentType[] types = this.enchs.getArray(e);
            if (types.length == 0) {
                return;
            }
            for (EnchantmentType type : types) {
                Enchantment ench = type.getType();
                assert (ench != null);
                i.addEnchantments(new EnchantmentType(ench, type.getLevel()));
            }
            this.item.change(e, new ItemType[]{i}, Changer.ChangeMode.SET);
        } else {
            EnchantmentType[] types = i.getEnchantmentTypes();
            if (types == null) {
                return;
            }
            for (EnchantmentType ench : types) {
                assert (ench != null);
                i.removeEnchantments(ench);
            }
            this.item.change(e, new ItemType[]{i}, Changer.ChangeMode.SET);
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.enchs == null ? "disenchant " + this.item.toString(e, debug) : "enchant " + this.item.toString(e, debug) + " with " + this.enchs;
    }

    static {
        Skript.registerEffect(EffEnchant.class, "enchant %~itemtypes% with %enchantmenttypes%", "disenchant %~itemtypes%");
    }
}

